/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.patterns;

import ch.njol.skript.patterns.ChoicePatternElement;
import ch.njol.skript.patterns.GroupPatternElement;
import ch.njol.skript.patterns.LiteralPatternElement;
import ch.njol.skript.patterns.ParseTagPatternElement;
import ch.njol.skript.patterns.PatternElement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;

abstract class Keyword {
    Keyword() {
    }

    abstract boolean isPresent(String var1);

    @Contract(value="_ -> new")
    public static Keyword[] buildKeywords(PatternElement first) {
        return Keyword.buildKeywords(first, true, 0);
    }

    @Contract(value="_, _, _ -> new")
    private static Keyword[] buildKeywords(PatternElement first, boolean starting, int depth) {
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        PatternElement next = first;
        while (next != null) {
            if (next instanceof LiteralPatternElement) {
                String literal = next.toString().trim();
                while (literal.contains("  ")) {
                    literal = literal.replace("  ", " ");
                }
                if (!literal.isEmpty()) {
                    keywords.add(new SimpleKeyword(literal, starting, next.next == null));
                }
            } else if (depth <= 1 && next instanceof ChoicePatternElement) {
                boolean finalStarting = starting;
                int finalDepth = depth;
                Set<Set<Keyword>> choices = ((ChoicePatternElement)next).getPatternElements().stream().map(element -> Keyword.buildKeywords(element, finalStarting, finalDepth)).map(ImmutableSet::copyOf).collect(Collectors.toSet());
                if (choices.stream().noneMatch(Collection::isEmpty)) {
                    keywords.add(new ChoiceKeyword(choices));
                }
            } else if (next instanceof GroupPatternElement) {
                Collections.addAll(keywords, Keyword.buildKeywords(((GroupPatternElement)next).getPatternElement(), starting, depth + 1));
            }
            if (!(next instanceof ParseTagPatternElement)) {
                starting = false;
            }
            next = next.originalNext;
        }
        return keywords.toArray(new Keyword[0]);
    }

    private static final class SimpleKeyword
    extends Keyword {
        private final String keyword;
        private final boolean starting;
        private final boolean ending;

        SimpleKeyword(String keyword, boolean starting, boolean ending) {
            this.keyword = keyword;
            this.starting = starting;
            this.ending = ending;
        }

        @Override
        public boolean isPresent(String expr) {
            if (this.starting) {
                return expr.startsWith(this.keyword);
            }
            if (this.ending) {
                return expr.endsWith(this.keyword);
            }
            return expr.contains(this.keyword);
        }

        public int hashCode() {
            return Objects.hash(this.keyword, this.starting, this.ending);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SimpleKeyword)) {
                return false;
            }
            SimpleKeyword other = (SimpleKeyword)obj;
            return this.keyword.equals(other.keyword) && this.starting == other.starting && this.ending == other.ending;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("keyword", (Object)this.keyword).add("starting", this.starting).add("ending", this.ending).toString();
        }
    }

    private static final class ChoiceKeyword
    extends Keyword {
        private final Set<Set<Keyword>> choices;

        ChoiceKeyword(Set<Set<Keyword>> choices) {
            this.choices = choices;
        }

        @Override
        public boolean isPresent(String expr) {
            return this.choices.stream().anyMatch(keywords -> keywords.stream().allMatch(keyword -> keyword.isPresent(expr)));
        }

        public int hashCode() {
            return Arrays.hashCode(this.choices.toArray());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChoiceKeyword)) {
                return false;
            }
            return this.choices.equals(((ChoiceKeyword)obj).choices);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("choices", (Object)this.choices.stream().map(Object::toString).collect(Collectors.joining(", "))).toString();
        }
    }
}

