/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Tab List Name")
@Description(value={"Represents the name of a player that shows up in the tab list."})
@Example(value="on join:\n\tplayer has permission \"name.red\"\n\tset the player's tab list name to \"&lt;green&gt;%player's name%\"\n")
@Since(value={"before 2.1"})
public class ExprTablistName
extends SimplePropertyExpression<Player, String> {
    @Override
    @Nullable
    public String convert(Player player) {
        return player.getPlayerListName();
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return CollectionUtils.array(String.class);
        }
        return null;
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        String name = delta != null ? (String)delta[0] : null;
        for (Player player : (Player[])this.getExpr().getArray(event)) {
            player.setPlayerListName(name);
        }
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return "tablist name";
    }

    static {
        ExprTablistName.register(ExprTablistName.class, String.class, "(player|tab)[ ]list name[s]", "players");
    }
}

