/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.lang.simplification.SimplifiedLiteral;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.ColorRGB;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="String Colors")
@Description(value={"Retrieve the first, the last, or all of the color objects or color codes of a string.", "The retrieved color codes of the string will be formatted with the color symbol."})
@Example.Examples(value={@Example(value="set {_colors::*} to the string colors of \"<red>hey<blue>yo\""), @Example(value="set {_color} to the first string color code of \"&aGoodbye!\"\nsend \"%{_color}%Howdy!\" to all players\n")})
@Since(value={"2.11"})
public class ExprStringColor
extends PropertyExpression<String, Object> {
    private static final StringColor[] STRING_COLORS = StringColor.values();
    private StringColor selectedState;
    private boolean getCodes;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.selectedState = STRING_COLORS[matchedPattern];
        this.getCodes = parseResult.hasTag("code");
        this.setExpr(exprs[0]);
        return true;
    }

    protected Object @Nullable [] get(Event event, String[] source) {
        ArrayList<Object> colors = new ArrayList<Object>();
        for (String string : (String[])this.getExpr().getArray(event)) {
            List<Object> stringColors = this.getColors(string);
            if (stringColors.isEmpty()) continue;
            colors.addAll(stringColors);
        }
        return colors.toArray(new Object[0]);
    }

    @Override
    public Class<?> getReturnType() {
        return this.getCodes ? String.class : Color.class;
    }

    @Override
    public Class<?>[] possibleReturnTypes() {
        return CollectionUtils.array(String.class, SkriptColor.class, ColorRGB.class);
    }

    @Override
    public boolean isSingle() {
        return this.selectedState != StringColor.ALL && this.getExpr().isSingle();
    }

    @Override
    public Expression<?> simplify() {
        if (this.getExpr() instanceof Literal) {
            return SimplifiedLiteral.fromExpression(this);
        }
        return this;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(event, debug);
        builder.append((Object)(switch (this.selectedState.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "all of the";
            case 1 -> "the first";
            case 2 -> "the last";
        }));
        if (this.getCodes) {
            builder.append((Object)"string color codes");
        } else {
            builder.append((Object)"string colors");
        }
        builder.append("of", this.getExpr());
        return builder.toString();
    }

    private List<Object> getColors(String string) {
        ArrayList<Object> colors = new ArrayList<Object>();
        int length = string.length();
        Object last = null;
        for (int index = 0; index < length; ++index) {
            Object result;
            if (string.charAt(index) != '\u00a7') continue;
            boolean checkHex = this.checkHex(string, index);
            SkriptColor checkChar = SkriptColor.fromColorChar(string.charAt(index + 1));
            if (checkHex) {
                String hexString = string.substring(index, index + 14);
                result = this.getCodes ? hexString : this.fromHex(hexString);
                last = result;
                colors.add(result);
                if (this.selectedState == StringColor.FIRST) break;
                index += 13;
                continue;
            }
            if (checkChar == null) continue;
            String colorString = string.substring(index, index + 2);
            result = this.getCodes ? colorString : checkChar;
            colors.add(result);
            last = result;
            if (this.selectedState == StringColor.FIRST) break;
            ++index;
        }
        if (this.selectedState == StringColor.LAST) {
            colors.clear();
            colors.add(last);
        }
        return colors;
    }

    private boolean checkHex(String string, int index) {
        int i;
        int length = string.length();
        if (length < index + 12) {
            return false;
        }
        if (string.charAt(index + 1) != 'x') {
            return false;
        }
        for (i = index + 2; i <= index; i += 2) {
            if (string.charAt(i) == '\u00a7') continue;
            return false;
        }
        for (i = index + 3; i <= index; i += 2) {
            char toCheck = string.charAt(i);
            if (toCheck < '0' || toCheck > 'f') {
                return false;
            }
            if (toCheck > '9' && toCheck < 'A') {
                return false;
            }
            if (toCheck <= 'F' || toCheck >= 'a') continue;
            return false;
        }
        return true;
    }

    private ColorRGB fromHex(@NotNull String hex) {
        int blue;
        int green;
        int red;
        if (hex.startsWith("\u00a7x")) {
            hex = hex.substring(2);
        }
        hex = hex.replaceAll("\u00a7", "");
        int length = hex.length();
        int alpha = 255;
        if (length == 6) {
            red = Integer.parseInt(hex.substring(0, 2), 16);
            green = Integer.parseInt(hex.substring(2, 4), 16);
            blue = Integer.parseInt(hex.substring(4, 6), 16);
        } else if (length == 8) {
            alpha = Integer.parseInt(hex.substring(0, 2), 16);
            red = Integer.parseInt(hex.substring(2, 4), 16);
            green = Integer.parseInt(hex.substring(4, 6), 16);
            blue = Integer.parseInt(hex.substring(6, 8), 16);
        } else {
            throw new UnsupportedOperationException("Unsupported hex format - requires #RRGGBB or #AARRGGBB");
        }
        return ColorRGB.fromRGBA(red, green, blue, alpha);
    }

    static {
        Skript.registerExpression(ExprStringColor.class, Object.class, ExpressionType.PROPERTY, "[all [of the|the]|the] string colo[u]r[s] [code:code[s]] of %strings%", "[the] first string colo[u]r[s] [code:code[s]] of %strings%", "[the] last string colo[u]r[s] [code:code[s]] of %strings%");
    }

    private static enum StringColor {
        ALL,
        FIRST,
        LAST;

    }
}

