/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="Sign Text")
@Description(value={"A line of text on a sign. Can be changed, but remember that there is a 16 character limit per line (including color codes that use 2 characters each)."})
@Example(value="on rightclick on sign:\n\tline 2 of the clicked block is \"[Heal]\":\n\t\theal the player\n\tset line 3 to \"%player%\"\n")
@Since(value={"1.3"})
public class ExprSignText
extends SimpleExpression<String> {
    private Expression<Number> line;
    private Expression<Block> block;
    static boolean hasUpdateBooleanBoolean;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.line = matchedPattern == 0 ? exprs[0] : new SimpleLiteral<Integer>(parseResult.mark, false);
        this.block = exprs[exprs.length - 1];
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Nullable
    protected String[] get(Event e) {
        Number l = this.line.getSingle(e);
        if (l == null) {
            return new String[0];
        }
        int line = l.intValue() - 1;
        if (line < 0 || line > 3) {
            return new String[0];
        }
        if (this.getTime() >= 0 && this.block.isDefault() && e instanceof SignChangeEvent && !Delay.isDelayed(e)) {
            return new String[]{((SignChangeEvent)e).getLine(line)};
        }
        Block b = this.block.getSingle(e);
        if (b == null) {
            return new String[0];
        }
        if (!(b.getState() instanceof Sign)) {
            return new String[0];
        }
        return new String[]{((Sign)b.getState()).getLine(line)};
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "line " + this.line.toString(e, debug) + " of " + this.block.toString(e, debug);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.SET) {
            return new Class[]{String.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        Number l = this.line.getSingle(e);
        if (l == null) {
            return;
        }
        int line = l.intValue() - 1;
        if (line < 0 || line > 3) {
            return;
        }
        Block b = this.block.getSingle(e);
        if (b == null) {
            return;
        }
        if (this.getTime() >= 0 && e instanceof SignChangeEvent && b.equals((Object)((SignChangeEvent)e).getBlock()) && !Delay.isDelayed(e)) {
            switch (mode) {
                case DELETE: {
                    ((SignChangeEvent)e).setLine(line, "");
                    break;
                }
                case SET: {
                    assert (delta != null);
                    ((SignChangeEvent)e).setLine(line, (String)delta[0]);
                }
            }
        } else {
            BlockState state = b.getState();
            if (!(state instanceof Sign)) {
                return;
            }
            Sign sign = (Sign)b.getState();
            switch (mode) {
                case DELETE: {
                    sign.setLine(line, "");
                    break;
                }
                case SET: {
                    assert (delta != null);
                    sign.setLine(line, (String)delta[0]);
                }
            }
            if (hasUpdateBooleanBoolean) {
                try {
                    sign.update(false, false);
                }
                catch (NoSuchMethodError err) {
                    hasUpdateBooleanBoolean = false;
                    sign.update();
                }
            } else {
                sign.update();
            }
        }
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, SignChangeEvent.class, this.block);
    }

    static {
        Skript.registerExpression(ExprSignText.class, String.class, ExpressionType.PROPERTY, "[the] line %number% [of %block%]", "[the] (1\u00a61st|1\u00a6first|2\u00a62nd|2\u00a6second|3\u00a63rd|3\u00a6third|4\u00a64th|4\u00a6fourth) line [of %block%]");
        hasUpdateBooleanBoolean = true;
    }
}

