/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="Message")
@Description(value={"The (chat) message of a chat event, the join message of a join event, the quit message of a quit event, the death message of a death event or the broadcasted message in a broadcast event. This expression is mostly useful for being changed."})
@Example.Examples(value={@Example(value="on chat:\n\tplayer has permission \"admin\"\n\tset message to \"&c%message%\"\n"), @Example(value="on first join:\n\tset join message to \"Welcome %player% to our awesome server!\"\n"), @Example(value="on join:\n\tplayer has played before\n\tset join message to \"Welcome back, %player%!\"\n"), @Example(value="on quit:\n\tif {vanish::%player's uuid%} is set:\n\t\tclear quit message\n\telse:\n\t\tset quit message to \"%player% left this awesome server!\"\n"), @Example(value="on death:\n\tset the death message to \"%player% died!\"\n"), @Example(value="on broadcast:\n\tset broadcast message to \"&a[BROADCAST] %broadcast message%\"\n")})
@Since(value={"1.4.6 (chat message), 1.4.9 (join & quit messages), 2.0 (death message), 2.9.0 (clear message), 2.10 (broadcasted message)"})
@Events(value={"chat", "join", "quit", "death", "broadcast"})
public class ExprMessage
extends SimpleExpression<String> {
    private MessageType type;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = MessageType.values()[matchedPattern];
        if (!this.getParser().isCurrentEvent(this.type.events)) {
            Skript.error("The " + this.type.name + " message can only be used in a " + this.type.name + " event", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected String[] get(Event e) {
        for (Class<? extends Event> c : this.type.events) {
            if (!c.isInstance(e)) continue;
            return new String[]{this.type.get(e)};
        }
        return new String[0];
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return CollectionUtils.array(String.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE);
        for (Class<? extends Event> c : this.type.events) {
            if (!c.isInstance(e)) continue;
            this.type.set(e, mode == Changer.ChangeMode.DELETE ? "" : delta[0].toString());
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + this.type.name + " message";
    }

    static {
        Skript.registerExpression(ExprMessage.class, String.class, ExpressionType.SIMPLE, MessageType.patterns);
    }

    private static enum MessageType {
        CHAT("chat", "[chat( |-)]message", new Class[]{AsyncPlayerChatEvent.class}){

            @Override
            String get(Event event) {
                return ((AsyncPlayerChatEvent)event).getMessage();
            }

            @Override
            void set(Event event, String message) {
                ((AsyncPlayerChatEvent)event).setMessage(message);
            }
        }
        ,
        JOIN("join", "(join|log[ ]in)( |-)message", new Class[]{PlayerJoinEvent.class}){

            @Override
            @Nullable
            String get(Event e) {
                return ((PlayerJoinEvent)e).getJoinMessage();
            }

            @Override
            void set(Event e, String message) {
                ((PlayerJoinEvent)e).setJoinMessage(message);
            }
        }
        ,
        QUIT("quit", "(quit|leave|log[ ]out|kick)( |-)message", new Class[]{PlayerQuitEvent.class, PlayerKickEvent.class}){

            @Override
            @Nullable
            String get(Event e) {
                if (e instanceof PlayerKickEvent) {
                    return ((PlayerKickEvent)e).getLeaveMessage();
                }
                return ((PlayerQuitEvent)e).getQuitMessage();
            }

            @Override
            void set(Event e, String message) {
                if (e instanceof PlayerKickEvent) {
                    ((PlayerKickEvent)e).setLeaveMessage(message);
                } else {
                    ((PlayerQuitEvent)e).setQuitMessage(message);
                }
            }
        }
        ,
        DEATH("death", "death( |-)message", new Class[]{EntityDeathEvent.class}){

            @Override
            @Nullable
            String get(Event e) {
                if (e instanceof PlayerDeathEvent) {
                    return ((PlayerDeathEvent)e).getDeathMessage();
                }
                return null;
            }

            @Override
            void set(Event e, String message) {
                if (e instanceof PlayerDeathEvent) {
                    ((PlayerDeathEvent)e).setDeathMessage(message);
                }
            }
        }
        ,
        BROADCAST("broadcast", "broadcast(-|[ed] )message", new Class[]{BroadcastMessageEvent.class}){

            @Override
            @Nullable
            String get(Event event) {
                if (event instanceof BroadcastMessageEvent) {
                    BroadcastMessageEvent broadcastMessageEvent = (BroadcastMessageEvent)event;
                    return broadcastMessageEvent.getMessage();
                }
                return null;
            }

            @Override
            void set(Event event, String message) {
                if (event instanceof BroadcastMessageEvent) {
                    BroadcastMessageEvent broadcastMessageEvent = (BroadcastMessageEvent)event;
                    broadcastMessageEvent.setMessage(message);
                }
            }
        };

        final String name;
        private final String pattern;
        final Class<? extends Event>[] events;
        static String[] patterns;

        private MessageType(String name, String pattern, Class<? extends Event> ... events) {
            this.name = name;
            this.pattern = "[the] " + pattern;
            this.events = events;
        }

        @Nullable
        abstract String get(Event var1);

        abstract void set(Event var1, String var2);

        static {
            patterns = new String[MessageType.values().length];
            for (int i = 0; i < patterns.length; ++i) {
                MessageType.patterns[i] = MessageType.values()[i].pattern;
            }
        }
    }
}

