/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="Inventory Close Reason")
@Description(value={"The <a href='/#inventoryclosereason'>inventory close reason</a> of an <a href='/#inventory_close'>inventory close event</a>."})
@Example(value="on inventory close:\n\tinventory close reason is teleport\n\tsend \"Your inventory closed due to teleporting!\" to player\n")
@Events(value={"Inventory Close"})
@Since(value={"2.8.0"})
public class ExprInventoryCloseReason
extends EventValueExpression<InventoryCloseEvent.Reason> {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent((Class<? extends Event>)InventoryCloseEvent.class)) {
            Skript.error("The 'inventory close reason' expression can only be used in an inventory close event");
            return false;
        }
        return true;
    }

    public ExprInventoryCloseReason() {
        super(InventoryCloseEvent.Reason.class);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "inventory close reason";
    }

    static {
        if (Skript.classExists("org.bukkit.event.inventory.InventoryCloseEvent$Reason")) {
            Skript.registerExpression(ExprInventoryCloseReason.class, InventoryCloseEvent.Reason.class, ExpressionType.SIMPLE, "[the] inventory clos(e|ing) (reason|cause)");
        }
    }
}

