/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Brushable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Dusted Stage")
@Description(value={"Represents how far the block has been uncovered.", "The only blocks that can currently be \"dusted\" are Suspicious Gravel and Suspicious Sand."})
@Example.Examples(value={@Example(value="send target block's maximum dusted stage"), @Example(value="set {_sand}'s dusted stage to 2")})
@Since(value={"2.12"})
@RequiredPlugins(value={"Minecraft 1.20+"})
public class ExprDustedStage
extends PropertyExpression<Object, Integer> {
    private static final boolean SUPPORTS_DUSTING = Skript.classExists("org.bukkit.block.data.Brushable");
    private boolean isMax;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.isMax = parseResult.hasTag("max");
        return true;
    }

    protected Integer @Nullable [] get(Event event, Object[] source) {
        return this.get(source, obj -> {
            Brushable brushable = this.getBrushable(obj);
            if (brushable != null) {
                return this.isMax ? brushable.getMaximumDusted() : brushable.getDusted();
            }
            return null;
        });
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (this.isMax) {
            Skript.error("Attempting to modify the max dusted stage is not supported.");
            return null;
        }
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.RESET -> CollectionUtils.array(Integer.class);
            default -> null;
        };
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (this.isMax) {
            return;
        }
        Integer value = delta != null && delta.length > 0 ? (Integer)delta[0] : null;
        for (Object obj : this.getExpr().getArray(event)) {
            Brushable brushable = this.getBrushable(obj);
            if (brushable == null) continue;
            int currentValue = brushable.getDusted();
            int maxValue = brushable.getMaximumDusted();
            int newValue = currentValue;
            switch (mode) {
                case SET: {
                    if (value == null) break;
                    newValue = value;
                    break;
                }
                case ADD: {
                    if (value == null) break;
                    newValue = currentValue + value;
                    break;
                }
                case REMOVE: {
                    if (value == null) break;
                    newValue = currentValue - value;
                    break;
                }
                case RESET: {
                    newValue = 0;
                    break;
                }
                default: {
                    return;
                }
            }
            newValue = Math.max(0, Math.min(newValue, maxValue));
            brushable.setDusted(newValue);
            if (!(obj instanceof Block)) continue;
            ((Block)obj).setBlockData((BlockData)brushable);
        }
    }

    @Nullable
    private Brushable getBrushable(Object obj) {
        if (obj instanceof Block) {
            Block block = (Block)obj;
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Brushable) {
                return (Brushable)blockData;
            }
        } else if (obj instanceof Brushable) {
            Brushable brushable = (Brushable)obj;
            return brushable;
        }
        return null;
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return this.getExpr().toString(event, debug) + "'s " + (this.isMax ? "maximum " : "") + " dusted stage";
    }

    static {
        if (SUPPORTS_DUSTING) {
            ExprDustedStage.register(ExprDustedStage.class, Integer.class, "[:max[imum]] dust[ed|ing] (value|stage|progress[ion])", "blocks/blockdatas");
        }
    }
}

