/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.EventRestrictedSyntax;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

@Name(value="Attacker")
@Description(value={"The attacker of a damage event, e.g. when a player attacks a zombie this expression represents the player.", "Please note that the attacker can also be a block, e.g. a cactus or lava, but this expression will not be set in these cases."})
@Example(value="on damage:\n\tattacker is a player\n\thealth of attacker is less than or equal to 2\n\tdamage victim by 1 heart\n")
@Since(value={"1.3"})
@Events(value={"damage", "death", "vehicle destroy"})
public class ExprAttacker
extends SimpleExpression<Entity>
implements EventRestrictedSyntax {
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        return true;
    }

    @Override
    public Class<? extends Event>[] supportedEvents() {
        return CollectionUtils.array(EntityDamageEvent.class, EntityDeathEvent.class, VehicleDamageEvent.class, VehicleDestroyEvent.class);
    }

    protected Entity[] get(Event e) {
        return new Entity[]{ExprAttacker.getAttacker(e)};
    }

    @Nullable
    static Entity getAttacker(@Nullable Event e) {
        if (e == null) {
            return null;
        }
        if (e instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent edbee = (EntityDamageByEntityEvent)e;
            if (edbee.getDamager() instanceof Projectile) {
                Projectile p = (Projectile)edbee.getDamager();
                ProjectileSource o = p.getShooter();
                if (o instanceof Entity) {
                    return (Entity)o;
                }
                return null;
            }
            return edbee.getDamager();
        }
        if (e instanceof EntityDeathEvent) {
            return ExprAttacker.getAttacker((Event)((EntityDeathEvent)e).getEntity().getLastDamageCause());
        }
        if (e instanceof VehicleDamageEvent) {
            return ((VehicleDamageEvent)e).getAttacker();
        }
        if (e instanceof VehicleDestroyEvent) {
            return ((VehicleDestroyEvent)e).getAttacker();
        }
        return null;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the attacker";
        }
        return Classes.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    static {
        Skript.registerExpression(ExprAttacker.class, Entity.class, ExpressionType.SIMPLE, "[the] (attacker|damager)");
    }
}

