/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.yggdrasil.Fields;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Armadillo;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Breeze;
import org.bukkit.entity.Camel;
import org.bukkit.entity.CamelHusk;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Cod;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Creaking;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Egg;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Marker;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Mule;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Parched;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.Warden;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.boat.AcaciaBoat;
import org.bukkit.entity.boat.AcaciaChestBoat;
import org.bukkit.entity.boat.BambooChestRaft;
import org.bukkit.entity.boat.BambooRaft;
import org.bukkit.entity.boat.BirchBoat;
import org.bukkit.entity.boat.BirchChestBoat;
import org.bukkit.entity.boat.CherryBoat;
import org.bukkit.entity.boat.CherryChestBoat;
import org.bukkit.entity.boat.DarkOakBoat;
import org.bukkit.entity.boat.DarkOakChestBoat;
import org.bukkit.entity.boat.JungleBoat;
import org.bukkit.entity.boat.JungleChestBoat;
import org.bukkit.entity.boat.MangroveBoat;
import org.bukkit.entity.boat.MangroveChestBoat;
import org.bukkit.entity.boat.OakBoat;
import org.bukkit.entity.boat.OakChestBoat;
import org.bukkit.entity.boat.PaleOakBoat;
import org.bukkit.entity.boat.PaleOakChestBoat;
import org.bukkit.entity.boat.SpruceBoat;
import org.bukkit.entity.boat.SpruceChestBoat;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEntityData
extends EntityData<Entity> {
    private static final List<SimpleEntityDataInfo> types = new ArrayList<SimpleEntityDataInfo>();
    private transient SimpleEntityDataInfo simpleInfo;

    @ApiStatus.Internal
    public static void addSimpleEntity(String codeName, Class<? extends Entity> entityClass) {
        SimpleEntityData.addSimpleEntity(codeName, entityClass, Kleenean.UNKNOWN);
    }

    @ApiStatus.Internal
    public static void addSimpleEntity(String codeName, Class<? extends Entity> entityClass, Kleenean allowSpawning) {
        types.add(new SimpleEntityDataInfo(codeName, entityClass, false, allowSpawning));
    }

    @ApiStatus.Internal
    public static void addSuperEntity(String codeName, Class<? extends Entity> entityClass) {
        SimpleEntityData.addSuperEntity(codeName, entityClass, Kleenean.UNKNOWN);
    }

    @ApiStatus.Internal
    public static void addSuperEntity(String codeName, Class<? extends Entity> entityClass, Kleenean allowSpawning) {
        types.add(new SimpleEntityDataInfo(codeName, entityClass, true, allowSpawning));
    }

    public SimpleEntityData() {
        this(Entity.class);
    }

    private SimpleEntityData(SimpleEntityDataInfo simpleInfo) {
        assert (simpleInfo != null);
        this.simpleInfo = simpleInfo;
        this.codeNameIndex = types.indexOf(simpleInfo);
    }

    public SimpleEntityData(Class<? extends Entity> entityClass) {
        assert (entityClass != null && entityClass.isInterface()) : entityClass;
        int i = 0;
        SimpleEntityDataInfo closestInfo = null;
        int closestPattern = 0;
        for (SimpleEntityDataInfo info : types) {
            if (info.c.isAssignableFrom(entityClass) && (closestInfo == null || closestInfo.c.isAssignableFrom(info.c))) {
                closestInfo = info;
                closestPattern = i;
            }
            ++i;
        }
        if (closestInfo != null) {
            this.simpleInfo = closestInfo;
            this.codeNameIndex = closestPattern;
            return;
        }
        throw new IllegalStateException();
    }

    public SimpleEntityData(Entity entity) {
        int i = 0;
        SimpleEntityDataInfo closestInfo = null;
        int closestPattern = 0;
        for (SimpleEntityDataInfo info : types) {
            if (info.c.isInstance(entity) && (closestInfo == null || closestInfo.c.isAssignableFrom(info.c))) {
                closestInfo = info;
                closestPattern = i;
            }
            ++i;
        }
        if (closestInfo != null) {
            this.simpleInfo = closestInfo;
            this.codeNameIndex = closestPattern;
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedCodeName, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.simpleInfo = types.get(matchedCodeName);
        assert (this.simpleInfo != null) : matchedCodeName;
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Entity> entityClass, @Nullable Entity entity) {
        assert (false);
        return false;
    }

    @Override
    public void set(Entity entity) {
    }

    @Override
    public boolean match(Entity entity) {
        if (this.simpleInfo.isSupertype) {
            return this.simpleInfo.c.isInstance(entity);
        }
        SimpleEntityDataInfo closest = null;
        for (SimpleEntityDataInfo info : types) {
            if (!info.c.isInstance(entity) || closest != null && !closest.c.isAssignableFrom(info.c)) continue;
            closest = info;
        }
        if (closest != null) {
            return this.simpleInfo.c == closest.c;
        }
        assert (false);
        return false;
    }

    @Override
    public Class<? extends Entity> getType() {
        return this.simpleInfo.c;
    }

    @Override
    @NotNull
    public EntityData<?> getSuperType() {
        return new SimpleEntityData(this.simpleInfo);
    }

    @Override
    protected int hashCode_i() {
        return this.simpleInfo.hashCode();
    }

    @Override
    protected boolean equals_i(EntityData<?> entityData) {
        if (!(entityData instanceof SimpleEntityData)) {
            return false;
        }
        SimpleEntityData other = (SimpleEntityData)entityData;
        return this.simpleInfo.equals(other.simpleInfo);
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        return this.simpleInfo.c == entityData.getType() || this.simpleInfo.isSupertype && this.simpleInfo.c.isAssignableFrom(entityData.getType());
    }

    @Override
    public boolean canSpawn(@Nullable World world) {
        if (this.simpleInfo.allowSpawning.isUnknown()) {
            return super.canSpawn(world);
        }
        if (world == null) {
            return false;
        }
        return this.simpleInfo.allowSpawning.isTrue();
    }

    @Override
    public Fields serialize() throws NotSerializableException {
        Fields fields = super.serialize();
        fields.putObject("info.codeName", this.simpleInfo.codeName);
        return fields;
    }

    @Override
    public void deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
        String codeName = fields.getAndRemoveObject("info.codeName", String.class);
        for (SimpleEntityDataInfo info : types) {
            if (!info.codeName.equals(codeName)) continue;
            this.simpleInfo = info;
            super.deserialize(fields);
            return;
        }
        throw new StreamCorruptedException("Invalid SimpleEntityDataInfo code name " + codeName);
    }

    static {
        SimpleEntityData.addSimpleEntity("zombie", Zombie.class);
        SimpleEntityData.addSuperEntity("skeleton", Skeleton.class);
        SimpleEntityData.addSimpleEntity("tnt", TNTPrimed.class);
        SimpleEntityData.addSimpleEntity("spider", Spider.class);
        SimpleEntityData.addSimpleEntity("player", Player.class);
        SimpleEntityData.addSimpleEntity("lightning bolt", LightningStrike.class);
        SimpleEntityData.addSimpleEntity("giant", Giant.class);
        SimpleEntityData.addSimpleEntity("ghast", Ghast.class);
        SimpleEntityData.addSimpleEntity("fish hook", FishHook.class);
        SimpleEntityData.addSuperEntity("fireball", Fireball.class, Kleenean.TRUE);
        SimpleEntityData.addSimpleEntity("small fireball", SmallFireball.class);
        SimpleEntityData.addSimpleEntity("large fireball", LargeFireball.class);
        SimpleEntityData.addSimpleEntity("ender pearl", EnderPearl.class);
        SimpleEntityData.addSimpleEntity("ender dragon", EnderDragon.class);
        SimpleEntityData.addSimpleEntity("ender crystal", EnderCrystal.class);
        SimpleEntityData.addSimpleEntity("dragon fireball", DragonFireball.class);
        SimpleEntityData.addSimpleEntity("egg", Egg.class);
        SimpleEntityData.addSimpleEntity("cave spider", CaveSpider.class);
        SimpleEntityData.addSimpleEntity("arrow", Arrow.class);
        SimpleEntityData.addSimpleEntity("squid", Squid.class);
        SimpleEntityData.addSimpleEntity("snow golem", Snowman.class);
        SimpleEntityData.addSimpleEntity("snowball", Snowball.class);
        SimpleEntityData.addSimpleEntity("slime", Slime.class);
        SimpleEntityData.addSimpleEntity("magma cube", MagmaCube.class);
        SimpleEntityData.addSimpleEntity("ender eye", EnderSignal.class);
        SimpleEntityData.addSimpleEntity("blaze", Blaze.class);
        SimpleEntityData.addSimpleEntity("zombie pigman", PigZombie.class);
        SimpleEntityData.addSimpleEntity("bottle of enchanting", ThrownExpBottle.class);
        SimpleEntityData.addSimpleEntity("iron golem", IronGolem.class);
        SimpleEntityData.addSimpleEntity("ocelot", Ocelot.class);
        SimpleEntityData.addSimpleEntity("wither skeleton", WitherSkeleton.class);
        SimpleEntityData.addSimpleEntity("firework", Firework.class, Kleenean.TRUE);
        SimpleEntityData.addSimpleEntity("wither", Wither.class);
        SimpleEntityData.addSimpleEntity("wither skull", WitherSkull.class);
        SimpleEntityData.addSimpleEntity("witch", Witch.class);
        SimpleEntityData.addSimpleEntity("bat", Bat.class);
        SimpleEntityData.addSimpleEntity("item frame", ItemFrame.class);
        SimpleEntityData.addSimpleEntity("painting", Painting.class);
        SimpleEntityData.addSimpleEntity("horse", Horse.class);
        SimpleEntityData.addSimpleEntity("skeleton horse", SkeletonHorse.class);
        SimpleEntityData.addSimpleEntity("undead horse", ZombieHorse.class);
        SimpleEntityData.addSimpleEntity("mule", Mule.class);
        SimpleEntityData.addSimpleEntity("donkey", Donkey.class);
        SimpleEntityData.addSimpleEntity("leash hitch", LeashHitch.class);
        SimpleEntityData.addSimpleEntity("elder guardian", ElderGuardian.class);
        SimpleEntityData.addSimpleEntity("normal guardian", Guardian.class);
        SimpleEntityData.addSimpleEntity("armor stand", ArmorStand.class);
        SimpleEntityData.addSimpleEntity("endermite", Endermite.class);
        SimpleEntityData.addSimpleEntity("silverfish", Silverfish.class);
        SimpleEntityData.addSimpleEntity("tipped arrow", TippedArrow.class);
        SimpleEntityData.addSimpleEntity("area effect cloud", AreaEffectCloud.class);
        SimpleEntityData.addSimpleEntity("shulker", Shulker.class);
        SimpleEntityData.addSimpleEntity("shulker bullet", ShulkerBullet.class);
        SimpleEntityData.addSimpleEntity("spectral arrow", SpectralArrow.class);
        SimpleEntityData.addSimpleEntity("husk", Husk.class);
        SimpleEntityData.addSimpleEntity("stray", Stray.class);
        SimpleEntityData.addSimpleEntity("polar bear", PolarBear.class);
        SimpleEntityData.addSimpleEntity("llama spit", LlamaSpit.class);
        SimpleEntityData.addSimpleEntity("vindicator", Vindicator.class);
        SimpleEntityData.addSimpleEntity("vex", Vex.class);
        SimpleEntityData.addSimpleEntity("evoker", Evoker.class);
        SimpleEntityData.addSimpleEntity("evoker fangs", EvokerFangs.class);
        SimpleEntityData.addSimpleEntity("illusioner", Illusioner.class);
        SimpleEntityData.addSimpleEntity("trident", Trident.class);
        SimpleEntityData.addSimpleEntity("puffer fish", PufferFish.class);
        SimpleEntityData.addSimpleEntity("cod", Cod.class);
        SimpleEntityData.addSimpleEntity("turtle", Turtle.class);
        SimpleEntityData.addSimpleEntity("drowned", Drowned.class);
        SimpleEntityData.addSimpleEntity("phantom", Phantom.class);
        SimpleEntityData.addSimpleEntity("dolphin", Dolphin.class);
        SimpleEntityData.addSimpleEntity("pillager", Pillager.class);
        SimpleEntityData.addSimpleEntity("ravager", Ravager.class);
        SimpleEntityData.addSimpleEntity("wandering trader", WanderingTrader.class);
        SimpleEntityData.addSimpleEntity("piglin", Piglin.class);
        SimpleEntityData.addSimpleEntity("hoglin", Hoglin.class);
        SimpleEntityData.addSimpleEntity("zoglin", Zoglin.class);
        SimpleEntityData.addSimpleEntity("piglin brute", PiglinBrute.class);
        SimpleEntityData.addSimpleEntity("glow squid", GlowSquid.class);
        SimpleEntityData.addSimpleEntity("marker", Marker.class);
        SimpleEntityData.addSimpleEntity("glow item frame", GlowItemFrame.class);
        SimpleEntityData.addSimpleEntity("allay", Allay.class);
        SimpleEntityData.addSimpleEntity("tadpole", Tadpole.class);
        SimpleEntityData.addSimpleEntity("warden", Warden.class);
        SimpleEntityData.addSimpleEntity("camel", Camel.class);
        SimpleEntityData.addSimpleEntity("sniffer", Sniffer.class);
        SimpleEntityData.addSimpleEntity("interaction", Interaction.class);
        if (Skript.isRunningMinecraft(1, 20, 3)) {
            SimpleEntityData.addSimpleEntity("breeze", Breeze.class);
            SimpleEntityData.addSimpleEntity("wind charge", WindCharge.class);
        }
        if (Skript.isRunningMinecraft(1, 20, 5)) {
            SimpleEntityData.addSimpleEntity("armadillo", Armadillo.class);
            SimpleEntityData.addSimpleEntity("bogged", Bogged.class);
        }
        if (Skript.isRunningMinecraft(1, 21, 2)) {
            SimpleEntityData.addSimpleEntity("creaking", Creaking.class);
            SimpleEntityData.addSimpleEntity("oak boat", OakBoat.class);
            SimpleEntityData.addSimpleEntity("dark oak boat", DarkOakBoat.class);
            SimpleEntityData.addSimpleEntity("pale oak boat", PaleOakBoat.class);
            SimpleEntityData.addSimpleEntity("acacia boat", AcaciaBoat.class);
            SimpleEntityData.addSimpleEntity("birch boat", BirchBoat.class);
            SimpleEntityData.addSimpleEntity("spruce boat", SpruceBoat.class);
            SimpleEntityData.addSimpleEntity("jungle boat", JungleBoat.class);
            SimpleEntityData.addSimpleEntity("bamboo raft", BambooRaft.class);
            SimpleEntityData.addSimpleEntity("mangrove boat", MangroveBoat.class);
            SimpleEntityData.addSimpleEntity("cherry boat", CherryBoat.class);
            SimpleEntityData.addSimpleEntity("oak chest boat", OakChestBoat.class);
            SimpleEntityData.addSimpleEntity("dark oak chest boat", DarkOakChestBoat.class);
            SimpleEntityData.addSimpleEntity("pale oak chest boat", PaleOakChestBoat.class);
            SimpleEntityData.addSimpleEntity("acacia chest boat", AcaciaChestBoat.class);
            SimpleEntityData.addSimpleEntity("birch chest boat", BirchChestBoat.class);
            SimpleEntityData.addSimpleEntity("spruce chest boat", SpruceChestBoat.class);
            SimpleEntityData.addSimpleEntity("jungle chest boat", JungleChestBoat.class);
            SimpleEntityData.addSimpleEntity("bamboo chest raft", BambooChestRaft.class);
            SimpleEntityData.addSimpleEntity("mangrove chest boat", MangroveChestBoat.class);
            SimpleEntityData.addSimpleEntity("cherry chest boat", CherryChestBoat.class);
            SimpleEntityData.addSuperEntity("boat", Boat.class);
            SimpleEntityData.addSuperEntity("any boat", Boat.class);
            SimpleEntityData.addSuperEntity("chest boat", ChestBoat.class);
            SimpleEntityData.addSuperEntity("any chest boat", ChestBoat.class);
        }
        if (Skript.isRunningMinecraft(1, 21, 6)) {
            SimpleEntityData.addSimpleEntity("happy ghast", HappyGhast.class);
        }
        if (Skript.isRunningMinecraft(1, 21, 9)) {
            SimpleEntityData.addSimpleEntity("copper golem", CopperGolem.class);
            SimpleEntityData.addSimpleEntity("mannequin", Mannequin.class);
        }
        if (Skript.isRunningMinecraft(1, 21, 11)) {
            SimpleEntityData.addSimpleEntity("camel husk", CamelHusk.class);
            SimpleEntityData.addSimpleEntity("parched", Parched.class);
        }
        SimpleEntityData.addSuperEntity("human", HumanEntity.class);
        SimpleEntityData.addSuperEntity("damageable", Damageable.class);
        SimpleEntityData.addSuperEntity("monster", Monster.class);
        SimpleEntityData.addSuperEntity("mob", Mob.class);
        SimpleEntityData.addSuperEntity("creature", Creature.class);
        SimpleEntityData.addSuperEntity("animal", Animals.class);
        SimpleEntityData.addSuperEntity("tameable", Tameable.class);
        SimpleEntityData.addSuperEntity("fish", Fish.class);
        SimpleEntityData.addSuperEntity("golem", Golem.class);
        SimpleEntityData.addSuperEntity("projectile", Projectile.class);
        SimpleEntityData.addSuperEntity("living entity", LivingEntity.class);
        SimpleEntityData.addSuperEntity("entity", Entity.class);
        SimpleEntityData.addSuperEntity("chested horse", ChestedHorse.class);
        SimpleEntityData.addSuperEntity("any horse", AbstractHorse.class);
        SimpleEntityData.addSuperEntity("guardian", Guardian.class);
        SimpleEntityData.addSuperEntity("water mob", WaterMob.class);
        SimpleEntityData.addSuperEntity("any fireball", Fireball.class);
        SimpleEntityData.addSuperEntity("illager", Illager.class);
        SimpleEntityData.addSuperEntity("spellcaster", Spellcaster.class);
        SimpleEntityData.addSuperEntity("raider", Raider.class);
        if (Skript.classExists("org.bukkit.entity.Enemy")) {
            SimpleEntityData.addSuperEntity("enemy", Enemy.class);
        }
        String[] codeNames = new String[types.size()];
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            codeNames[i++] = info.codeName;
        }
        EntityData.register(SimpleEntityData.class, "simple", Entity.class, 0, codeNames);
    }

    public static final class SimpleEntityDataInfo {
        final String codeName;
        final Class<? extends Entity> c;
        final boolean isSupertype;
        final Kleenean allowSpawning;

        SimpleEntityDataInfo(String codeName, Class<? extends Entity> c, boolean isSupertype, Kleenean allowSpawning) {
            this.codeName = codeName;
            this.c = c;
            this.isSupertype = isSupertype;
            this.allowSpawning = allowSpawning;
        }

        public int hashCode() {
            return this.c.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SimpleEntityDataInfo)) {
                return false;
            }
            SimpleEntityDataInfo other = (SimpleEntityDataInfo)obj;
            if (this.c != other.c) {
                return false;
            }
            assert (this.codeName.equals(other.codeName));
            assert (this.isSupertype == other.isSupertype);
            return true;
        }
    }
}

