/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Example;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Enforce Whitelist")
@Description(value={"Enforces or un-enforce a server's whitelist.", "All non-whitelisted players will be kicked upon enforcing the whitelist."})
@Example.Examples(value={@Example(value="enforce the whitelist"), @Example(value="unenforce the whitelist")})
@Since(value={"2.9.0"})
@RequiredPlugins(value={"MC 1.17+"})
public class EffEnforceWhitelist
extends Effect {
    private static String NOT_WHITELISTED_MESSAGE = "You are not whitelisted on this server!";
    private boolean enforce;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.enforce = !parseResult.hasTag("un");
        return true;
    }

    @Override
    protected void execute(Event event) {
        Bukkit.setWhitelistEnforced((boolean)this.enforce);
        EffEnforceWhitelist.reloadWhitelist();
    }

    public static void reloadWhitelist() {
        Bukkit.reloadWhitelist();
        if (!Bukkit.hasWhitelist() || !Bukkit.isWhitelistEnforced()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.isWhitelisted() || player.isOp()) continue;
            player.kickPlayer(Utils.replaceChatStyles(NOT_WHITELISTED_MESSAGE));
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return (!this.enforce ? "un" : "") + "enforce the whitelist";
    }

    static {
        try {
            YamlConfiguration spigotYml = YamlConfiguration.loadConfiguration((File)new File("spigot.yml"));
            NOT_WHITELISTED_MESSAGE = spigotYml.getString("messages.whitelist", NOT_WHITELISTED_MESSAGE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Skript.registerEffect(EffEnforceWhitelist.class, "[:un]enforce [the] [server] white[ ]list");
    }
}

