/*
 * Decompiled with CFR 0.152.
 */
package us.ironcladnetwork.blockback;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class SoundConfig {
    private static SoundConfig instance;
    private final JavaPlugin plugin;
    private final File configFile;
    private FileConfiguration config;
    private SoundSettings barkBackSettings;
    private SoundSettings pathBackSettings;
    private SoundSettings farmBackSettings;

    public static void init(JavaPlugin plugin) {
        instance = new SoundConfig(plugin);
    }

    public static SoundConfig getInstance() {
        return instance;
    }

    private SoundConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        File dataFolder = plugin.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        this.configFile = new File(dataFolder, "sounds.yml");
        this.loadConfig();
    }

    private void loadConfig() {
        if (!this.configFile.exists()) {
            this.createDefaultConfig();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.loadSoundSettings();
    }

    private void createDefaultConfig() {
        try {
            this.configFile.createNewFile();
            this.config = new YamlConfiguration();
            this.config.set("barkback.sound", (Object)"ITEM_AXE_STRIP");
            this.config.set("barkback.category", (Object)"BLOCKS");
            this.config.set("barkback.volume", (Object)1.0);
            this.config.set("barkback.pitch", (Object)1.0);
            this.config.set("barkback.enabled", (Object)true);
            this.config.set("pathback.sound", (Object)"ITEM_SHOVEL_FLATTEN");
            this.config.set("pathback.category", (Object)"BLOCKS");
            this.config.set("pathback.volume", (Object)1.0);
            this.config.set("pathback.pitch", (Object)1.0);
            this.config.set("pathback.enabled", (Object)true);
            this.config.set("farmback.sound", (Object)"ITEM_HOE_TILL");
            this.config.set("farmback.category", (Object)"BLOCKS");
            this.config.set("farmback.volume", (Object)1.0);
            this.config.set("farmback.pitch", (Object)1.0);
            this.config.set("farmback.enabled", (Object)true);
            this.config.options().setHeader(Arrays.asList("BlockBack Sound Configuration", "Configure sounds, volumes, and pitches for each feature.", "", "Sound Options: Any valid Bukkit Sound enum value", "Category Options: MASTER, MUSIC, RECORD, WEATHER, BLOCK, HOSTILE, NEUTRAL, PLAYER, AMBIENT, VOICE", "Volume: 0.0 to 10.0 (1.0 = normal volume)", "Pitch: 0.5 to 2.0 (1.0 = normal pitch, higher = higher pitch)", "Enabled: true/false to enable/disable sounds for each feature"));
            this.config.save(this.configFile);
            this.plugin.getLogger().info("Created default sounds.yml configuration file");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not create sounds.yml: " + e.getMessage());
        }
    }

    private void loadSoundSettings() {
        SoundCategory category;
        Sound sound;
        String categoryName;
        String soundName;
        try {
            soundName = this.config.getString("barkback.sound", "ITEM_AXE_STRIP");
            categoryName = this.config.getString("barkback.category", "BLOCKS");
            try {
                sound = Sound.valueOf((String)soundName);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid BarkBack sound '" + soundName + "', using default ITEM_AXE_STRIP");
                sound = Sound.ITEM_AXE_STRIP;
            }
            try {
                category = SoundCategory.valueOf((String)categoryName);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid BarkBack sound category '" + categoryName + "', using default BLOCKS");
                category = SoundCategory.BLOCKS;
            }
            this.barkBackSettings = new SoundSettings(sound, category, this.validateVolume(this.config.getDouble("barkback.volume", 1.0), "BarkBack"), this.validatePitch(this.config.getDouble("barkback.pitch", 1.0), "BarkBack"), this.config.getBoolean("barkback.enabled", true));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load BarkBack sound settings: " + e.getMessage());
            this.barkBackSettings = new SoundSettings(Sound.ITEM_AXE_STRIP, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
        try {
            soundName = this.config.getString("pathback.sound", "ITEM_SHOVEL_FLATTEN");
            categoryName = this.config.getString("pathback.category", "BLOCKS");
            try {
                sound = Sound.valueOf((String)soundName);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid PathBack sound '" + soundName + "', using default ITEM_SHOVEL_FLATTEN");
                sound = Sound.ITEM_SHOVEL_FLATTEN;
            }
            try {
                category = SoundCategory.valueOf((String)categoryName);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid PathBack sound category '" + categoryName + "', using default BLOCKS");
                category = SoundCategory.BLOCKS;
            }
            this.pathBackSettings = new SoundSettings(sound, category, this.validateVolume(this.config.getDouble("pathback.volume", 1.0), "PathBack"), this.validatePitch(this.config.getDouble("pathback.pitch", 1.0), "PathBack"), this.config.getBoolean("pathback.enabled", true));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load PathBack sound settings: " + e.getMessage());
            this.pathBackSettings = new SoundSettings(Sound.ITEM_SHOVEL_FLATTEN, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
        try {
            soundName = this.config.getString("farmback.sound", "ITEM_HOE_TILL");
            categoryName = this.config.getString("farmback.category", "BLOCKS");
            try {
                sound = Sound.valueOf((String)soundName);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid FarmBack sound '" + soundName + "', using default ITEM_HOE_TILL");
                sound = Sound.ITEM_HOE_TILL;
            }
            try {
                category = SoundCategory.valueOf((String)categoryName);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid FarmBack sound category '" + categoryName + "', using default BLOCKS");
                category = SoundCategory.BLOCKS;
            }
            this.farmBackSettings = new SoundSettings(sound, category, this.validateVolume(this.config.getDouble("farmback.volume", 1.0), "FarmBack"), this.validatePitch(this.config.getDouble("farmback.pitch", 1.0), "FarmBack"), this.config.getBoolean("farmback.enabled", true));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load FarmBack sound settings: " + e.getMessage());
            this.farmBackSettings = new SoundSettings(Sound.ITEM_HOE_TILL, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    public void reloadConfig() {
        this.loadConfig();
        this.plugin.getLogger().info("Sound configuration reloaded");
    }

    public SoundSettings getBarkBackSettings() {
        return this.barkBackSettings;
    }

    public SoundSettings getPathBackSettings() {
        return this.pathBackSettings;
    }

    public SoundSettings getFarmBackSettings() {
        return this.farmBackSettings;
    }

    private float validateVolume(double value, String featureName) {
        if (value < 0.0) {
            this.plugin.getLogger().warning(featureName + " volume " + value + " is below minimum (0.0), using 0.0");
            return 0.0f;
        }
        if (value > 10.0) {
            this.plugin.getLogger().warning(featureName + " volume " + value + " is above maximum (10.0), using 10.0");
            return 10.0f;
        }
        return (float)value;
    }

    private float validatePitch(double value, String featureName) {
        if (value < 0.5) {
            this.plugin.getLogger().warning(featureName + " pitch " + value + " is below minimum (0.5), using 0.5");
            return 0.5f;
        }
        if (value > 2.0) {
            this.plugin.getLogger().warning(featureName + " pitch " + value + " is above maximum (2.0), using 2.0");
            return 2.0f;
        }
        return (float)value;
    }

    public static class SoundSettings {
        public final Sound sound;
        public final SoundCategory category;
        public final float volume;
        public final float pitch;
        public final boolean enabled;

        public SoundSettings(Sound sound, SoundCategory category, float volume, float pitch, boolean enabled) {
            this.sound = sound;
            this.category = category;
            this.volume = volume;
            this.pitch = pitch;
            this.enabled = enabled;
        }
    }
}

