/*
 * Decompiled with CFR 0.152.
 */
package us.ironcladnetwork.blockback;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import us.ironcladnetwork.blockback.PlayerDataManager;
import us.ironcladnetwork.blockback.SoundConfig;

public class EventListener
implements Listener {
    private static final EnumSet<Material> AXES = EnumSet.of(Material.WOODEN_AXE, new Material[]{Material.STONE_AXE, Material.GOLDEN_AXE, Material.IRON_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE});
    private static final EnumSet<Material> SHOVELS = EnumSet.of(Material.WOODEN_SHOVEL, new Material[]{Material.STONE_SHOVEL, Material.GOLDEN_SHOVEL, Material.IRON_SHOVEL, Material.DIAMOND_SHOVEL, Material.NETHERITE_SHOVEL});
    private static final EnumSet<Material> HOES = EnumSet.of(Material.WOODEN_HOE, new Material[]{Material.STONE_HOE, Material.GOLDEN_HOE, Material.IRON_HOE, Material.DIAMOND_HOE, Material.NETHERITE_HOE});
    private static final Map<Material, Material> STRIPPED_TO_UNSTRIPPED = new HashMap<Material, Material>();

    @EventHandler
    public void onBlockClick(PlayerInteractEvent e) {
        SoundConfig.SoundSettings soundSettings;
        Material unstrippedMaterial;
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = e.getClickedBlock();
        Player player = e.getPlayer();
        ItemStack item = e.getItem();
        if (block == null || item == null) {
            return;
        }
        PlayerDataManager playerData = PlayerDataManager.getInstance();
        SoundConfig soundConfig = SoundConfig.getInstance();
        if (playerData == null || soundConfig == null) {
            return;
        }
        Material itemType = item.getType();
        if (player.hasPermission("blockback.bark") && playerData.isBarkBackEnabled(player) && AXES.contains(itemType) && block.getBlockData() instanceof Orientable && (unstrippedMaterial = STRIPPED_TO_UNSTRIPPED.get(block.getType())) != null) {
            Orientable orientable = (Orientable)block.getBlockData();
            Axis axis = orientable.getAxis();
            if (axis != null) {
                this.setBlockWithAxis(block, unstrippedMaterial, axis);
            } else {
                block.setType(unstrippedMaterial);
            }
            SoundConfig.SoundSettings soundSettings2 = soundConfig.getBarkBackSettings();
            if (soundSettings2.enabled) {
                player.playSound(player.getLocation(), soundSettings2.sound, soundSettings2.category, soundSettings2.volume, soundSettings2.pitch);
            }
            e.setCancelled(true);
            return;
        }
        if (player.hasPermission("blockback.path") && playerData.isPathBackEnabled(player) && SHOVELS.contains(itemType) && block.getType() == Material.DIRT_PATH) {
            block.setType(Material.DIRT);
            soundSettings = soundConfig.getPathBackSettings();
            if (soundSettings.enabled) {
                player.playSound(player.getLocation(), soundSettings.sound, soundSettings.category, soundSettings.volume, soundSettings.pitch);
            }
            e.setCancelled(true);
            return;
        }
        if (player.hasPermission("blockback.farm") && playerData.isFarmBackEnabled(player) && HOES.contains(itemType) && block.getType() == Material.FARMLAND) {
            block.setType(Material.DIRT);
            soundSettings = soundConfig.getFarmBackSettings();
            if (soundSettings.enabled) {
                player.playSound(player.getLocation(), soundSettings.sound, soundSettings.category, soundSettings.volume, soundSettings.pitch);
            }
            e.setCancelled(true);
            return;
        }
    }

    private void setBlockWithAxis(Block block, Material material, Axis axis) {
        block.setType(material);
        BlockData newData = block.getBlockData();
        if (newData instanceof Orientable && axis != null) {
            Orientable orientable = (Orientable)newData;
            orientable.setAxis(axis);
            block.setBlockData((BlockData)orientable);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerDataManager playerData = PlayerDataManager.getInstance();
        if (playerData != null) {
            playerData.removeFromCache(event.getPlayer());
        }
    }

    static {
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_OAK_LOG, Material.OAK_LOG);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_OAK_WOOD, Material.OAK_WOOD);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_SPRUCE_LOG, Material.SPRUCE_LOG);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_SPRUCE_WOOD, Material.SPRUCE_WOOD);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_BIRCH_LOG, Material.BIRCH_LOG);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_BIRCH_WOOD, Material.BIRCH_WOOD);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_JUNGLE_LOG, Material.JUNGLE_LOG);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_JUNGLE_WOOD, Material.JUNGLE_WOOD);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_ACACIA_LOG, Material.ACACIA_LOG);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_ACACIA_WOOD, Material.ACACIA_WOOD);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_DARK_OAK_LOG, Material.DARK_OAK_LOG);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_DARK_OAK_WOOD, Material.DARK_OAK_WOOD);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_MANGROVE_LOG, Material.MANGROVE_LOG);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_MANGROVE_WOOD, Material.MANGROVE_WOOD);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_CHERRY_LOG, Material.CHERRY_LOG);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_CHERRY_WOOD, Material.CHERRY_WOOD);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_CRIMSON_HYPHAE, Material.CRIMSON_HYPHAE);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_CRIMSON_STEM, Material.CRIMSON_STEM);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_WARPED_HYPHAE, Material.WARPED_HYPHAE);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_WARPED_STEM, Material.WARPED_STEM);
        STRIPPED_TO_UNSTRIPPED.put(Material.STRIPPED_BAMBOO_BLOCK, Material.BAMBOO_BLOCK);
    }
}

