/*
 * Decompiled with CFR 0.152.
 */
package us.ironcladnetwork.blockback;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import us.ironcladnetwork.blockback.PlayerDataManager;
import us.ironcladnetwork.blockback.SoundConfig;

public class CommandManager
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        PlayerDataManager playerData = PlayerDataManager.getInstance();
        if (playerData == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Plugin not properly initialized. Please contact an administrator.");
            return true;
        }
        if (command.getName().equalsIgnoreCase("barkback")) {
            return this.handleToggleCommand(player, playerData, "BarkBack", "blockback.bark", playerData::isBarkBackEnabled, playerData::setBarkBack);
        }
        if (command.getName().equalsIgnoreCase("pathback")) {
            return this.handleToggleCommand(player, playerData, "PathBack", "blockback.path", playerData::isPathBackEnabled, playerData::setPathBack);
        }
        if (command.getName().equalsIgnoreCase("farmback")) {
            return this.handleToggleCommand(player, playerData, "FarmBack", "blockback.farm", playerData::isFarmBackEnabled, playerData::setFarmBack);
        }
        if (command.getName().equalsIgnoreCase("blockback")) {
            if (args.length == 0) {
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== BlockBack Status ===");
                String barkStatus = playerData.isBarkBackEnabled(player) ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled";
                String pathStatus = playerData.isPathBackEnabled(player) ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled";
                String farmStatus = playerData.isFarmBackEnabled(player) ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled";
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "BarkBack: " + barkStatus);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "PathBack: " + pathStatus);
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "FarmBack: " + farmStatus);
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Use /barkback, /pathback, /farmback to toggle features.");
                if (player.hasPermission("blockback.reload")) {
                    player.sendMessage(String.valueOf(ChatColor.GRAY) + "Use /blockback reload to reload configuration.");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!player.hasPermission("blockback.reload")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                    return true;
                }
                SoundConfig soundConfig = SoundConfig.getInstance();
                if (soundConfig == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Sound configuration not initialized. Please contact an administrator.");
                    return true;
                }
                soundConfig.reloadConfig();
                playerData.reloadConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "BlockBack configuration reloaded successfully!");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Use /blockback for help.");
            return true;
        }
        return false;
    }

    private boolean handleToggleCommand(Player player, PlayerDataManager playerData, String featureName, String permission, Function<Player, Boolean> getCurrentState, BiConsumer<Player, Boolean> setNewState) {
        if (!player.hasPermission(permission)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        boolean current = getCurrentState.apply(player);
        setNewState.accept(player, !current);
        String status = !current ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled";
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + featureName + " is now " + status + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }
}

