/*
 * Decompiled with CFR 0.152.
 */
package us.ironcladnetwork.blockback;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import us.ironcladnetwork.blockback.CommandManager;
import us.ironcladnetwork.blockback.EventListener;
import us.ironcladnetwork.blockback.PlayerDataManager;
import us.ironcladnetwork.blockback.SoundConfig;

public final class Blockback
extends JavaPlugin {
    public void onEnable() {
        String[] requiredCommands;
        CommandManager commandManager;
        this.getLogger().info("BlockBack is starting...");
        PlayerDataManager.init(this);
        SoundConfig.init(this);
        try {
            Bukkit.getPluginManager().registerEvents((Listener)new EventListener(), (Plugin)this);
            this.getLogger().info("EventListener registered successfully.");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to register EventListener: " + e.getMessage());
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            commandManager = new CommandManager();
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to create CommandManager: " + e.getMessage());
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        int failedCommands = 0;
        for (String commandName : requiredCommands = new String[]{"barkback", "pathback", "farmback", "blockback"}) {
            if (this.getCommand(commandName) != null) {
                try {
                    this.getCommand(commandName).setExecutor((CommandExecutor)commandManager);
                    this.getLogger().info("Command '" + commandName + "' registered successfully.");
                }
                catch (Exception e) {
                    this.getLogger().severe("Failed to register executor for command '" + commandName + "': " + e.getMessage());
                    ++failedCommands;
                }
                continue;
            }
            this.getLogger().severe("Command '" + commandName + "' not found in plugin.yml!");
            ++failedCommands;
        }
        if (failedCommands > 0) {
            this.getLogger().severe("Failed to register " + failedCommands + " out of " + requiredCommands.length + " commands. Plugin functionality will be limited.");
            if (failedCommands == requiredCommands.length) {
                this.getLogger().severe("All commands failed to register. Disabling plugin.");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        this.getLogger().info("BlockBack has loaded successfully!");
    }

    public void onDisable() {
        this.getLogger().info("BlockBack is shutting down...");
        PlayerDataManager manager = PlayerDataManager.getInstance();
        if (manager != null) {
            boolean saveCompleted = manager.shutdown(5);
            if (saveCompleted) {
                this.getLogger().info("All player data saved successfully during shutdown.");
            } else {
                this.getLogger().warning("Player data save may be incomplete due to shutdown timeout.");
            }
        }
        this.getLogger().info("BlockBack is unloaded...");
    }
}

