/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.utility.paper;

import com.github.sirblobman.api.utility.paper.CommandData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PaperPluginCommand
extends Command
implements PluginIdentifiableCommand {
    private final Plugin plugin;
    private final CommandData commandData;

    protected PaperPluginCommand(@NotNull Plugin plugin, @NotNull String name, @NotNull CommandData commandData) {
        super(name);
        String permissionMessage;
        String permission;
        String description;
        this.plugin = plugin;
        this.commandData = commandData;
        String usage = commandData.getUsage();
        if (usage != null) {
            this.setUsage(usage);
        }
        if ((description = commandData.getDescription()) != null) {
            this.setDescription(description);
        }
        if ((permission = commandData.getPermission()) != null) {
            this.setPermission(permission);
        }
        if ((permissionMessage = commandData.getPermissionMessage()) != null) {
            this.setPermissionMessage(permissionMessage);
        }
        Set<String> aliases = commandData.getAliases();
        this.setAliases(new ArrayList<String>(aliases));
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        boolean success;
        Plugin plugin = this.getPlugin();
        CommandData commandData = this.getCommandData();
        CommandExecutor executor = commandData.getCommandExecutor();
        if (!plugin.isEnabled()) {
            throw new CommandException("Cannot execute command '" + commandLabel + "' in plugin " + plugin.getDescription().getFullName() + " - plugin is disabled.");
        }
        if (!this.testPermission(sender)) {
            return true;
        }
        try {
            success = executor.onCommand(sender, (Command)this, commandLabel, args);
        }
        catch (Throwable ex) {
            throw new CommandException("Unhandled exception executing command '" + commandLabel + "' in plugin " + plugin.getDescription().getFullName(), ex);
        }
        String usageMessage = commandData.getUsage();
        if (usageMessage == null) {
            usageMessage = "";
        }
        if (!success && !usageMessage.isEmpty()) {
            for (String line : usageMessage.replace("<command>", commandLabel).split("\n")) {
                sender.sendMessage(line);
            }
        }
        return success;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        CommandData commandData = this.getCommandData();
        TabExecutor completer = commandData.getTabExecutor();
        CommandExecutor executor = commandData.getCommandExecutor();
        List completions = null;
        try {
            if (completer != null) {
                completions = completer.onTabComplete(sender, (Command)this, alias, args);
            }
            if (completions == null && executor instanceof TabCompleter) {
                completions = ((TabCompleter)executor).onTabComplete(sender, (Command)this, alias, args);
            }
        }
        catch (Throwable ex) {
            StringBuilder message = new StringBuilder();
            message.append("Unhandled exception during tab completion for command '/").append(alias).append(' ');
            for (String arg : args) {
                message.append(arg).append(' ');
            }
            message.deleteCharAt(message.length() - 1).append("' in plugin ").append(this.plugin.getDescription().getFullName());
            throw new CommandException(message.toString(), ex);
        }
        if (completions == null) {
            return super.tabComplete(sender, alias, args);
        }
        return completions;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public CommandData getCommandData() {
        return this.commandData;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(", ").append(this.plugin.getDescription().getFullName()).append(')');
        return stringBuilder.toString();
    }
}

