/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.utility.paper;

import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.utility.paper.CommandData;
import com.github.sirblobman.api.utility.paper.ComponentConverter;
import com.github.sirblobman.api.utility.paper.PaperPluginCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaperHelper {
    public static void setDeathMessage(@NotNull Component message, @NotNull PlayerDeathEvent e) {
        net.kyori.adventure.text.Component paperMessage = ComponentConverter.shadedToNormal(message);
        e.deathMessage(paperMessage);
    }

    public static double @NotNull [] getServerTpsValues() {
        Server server = Bukkit.getServer();
        return server.getTPS();
    }

    public static double getServer1mTps() {
        Server server = Bukkit.getServer();
        double[] tpsArray = server.getTPS();
        return tpsArray[0];
    }

    @Nullable
    public static Component getCustomName(@NotNull Entity entity) {
        net.kyori.adventure.text.Component paperName = entity.customName();
        if (paperName == null) {
            return null;
        }
        return ComponentConverter.normalToShaded(paperName);
    }

    public static void setCustomName(@NotNull Entity entity, @Nullable Component name) {
        if (name == null) {
            entity.customName(null);
            return;
        }
        net.kyori.adventure.text.Component paperName = ComponentConverter.shadedToNormal(name);
        entity.customName(paperName);
    }

    @Nullable
    public static Component getDisplayName(@NotNull ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        if (itemMeta.hasDisplayName()) {
            net.kyori.adventure.text.Component paperName = itemMeta.displayName();
            if (paperName == null) {
                return null;
            }
            return ComponentConverter.normalToShaded(paperName);
        }
        return null;
    }

    @Nullable
    public static List<Component> getLore(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        if (itemMeta.hasLore()) {
            List paperLore = itemMeta.lore();
            if (paperLore == null) {
                return null;
            }
            return paperLore.parallelStream().map(ComponentConverter::normalToShaded).collect(Collectors.toList());
        }
        return null;
    }

    public static void registerCommand(Plugin plugin, CommandData commandData) {
        String pluginName = plugin.getName();
        String commandName = commandData.getName();
        PaperPluginCommand command = new PaperPluginCommand(plugin, commandName, commandData);
        Server server = plugin.getServer();
        CommandMap commandMap = server.getCommandMap();
        commandMap.register(commandName, pluginName, (Command)command);
        if (!command.isRegistered()) {
            throw new IllegalStateException("Failed to register command '/" + commandName + "'.");
        }
    }

    public static void setDisplayName(@NotNull ItemStack item, @Nullable Component name) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        if (name == null) {
            itemMeta.displayName(null);
        } else {
            net.kyori.adventure.text.Component paperName = ComponentConverter.shadedToNormal(name);
            itemMeta.displayName(paperName);
        }
        item.setItemMeta(itemMeta);
    }

    public static void setLore(@NotNull ItemStack item, @Nullable List<Component> lore) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        if (lore == null) {
            itemMeta.lore(null);
        } else {
            ArrayList<net.kyori.adventure.text.Component> paperLore = new ArrayList<net.kyori.adventure.text.Component>();
            for (Component line : lore) {
                net.kyori.adventure.text.Component loreLine = ComponentConverter.shadedToNormal(line);
                paperLore.add(loreLine);
            }
            itemMeta.lore(paperLore);
        }
        item.setItemMeta(itemMeta);
    }

    @NotNull
    public static Inventory createInventory(@Nullable InventoryHolder holder, int size, @NotNull Component title) {
        net.kyori.adventure.text.Component paperTitle = ComponentConverter.shadedToNormal(title);
        if (size == 5) {
            return Bukkit.createInventory((InventoryHolder)holder, (InventoryType)InventoryType.HOPPER, (net.kyori.adventure.text.Component)paperTitle);
        }
        if (size < 9) {
            throw new IllegalArgumentException("size must be equal to 5 or at least 9");
        }
        if (size > 54) {
            throw new IllegalArgumentException("size cannot be more than 54");
        }
        if (size % 9 != 0) {
            throw new IllegalArgumentException("size must be equal to 5 or divisible by 9");
        }
        return Bukkit.createInventory((InventoryHolder)holder, (int)size, (net.kyori.adventure.text.Component)paperTitle);
    }
}

