/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.utility.paper;

import com.github.sirblobman.api.utility.VersionUtility;

public final class PaperChecker {
    private static Boolean USE_PAPER = null;
    private static Boolean COMPONENT_SUPPORT = null;
    private static Boolean PAPER_PLUGIN_SUPPORT = null;

    public static boolean isPaper() {
        if (USE_PAPER != null) {
            return USE_PAPER;
        }
        try {
            Class.forName("io.papermc.paper.configuration.Configuration");
            USE_PAPER = true;
            return USE_PAPER;
        }
        catch (ClassCastException | NoClassDefFoundError | ReflectiveOperationException ex1) {
            try {
                Class.forName("com.destroystokyo.paper.PaperConfig");
                USE_PAPER = true;
                return USE_PAPER;
            }
            catch (ClassCastException | NoClassDefFoundError | ReflectiveOperationException ex2) {
                USE_PAPER = false;
                return USE_PAPER;
            }
        }
    }

    public static boolean hasNativeComponentSupport() {
        if (COMPONENT_SUPPORT != null) {
            return COMPONENT_SUPPORT;
        }
        int minorVersion = VersionUtility.getMinorVersion();
        if (minorVersion < 16) {
            COMPONENT_SUPPORT = false;
            return COMPONENT_SUPPORT;
        }
        try {
            Class<?>[] class_CommandSender_interfaces;
            Class<?> class_CommandSender = Class.forName("org.bukkit.command.CommandSender");
            Class<?> class_Audience = Class.forName("net.kyori.adventure.audience.Audience");
            for (Class<?> class_CommandSender_interface : class_CommandSender_interfaces = class_CommandSender.getInterfaces()) {
                if (!class_Audience.equals(class_CommandSender_interface)) continue;
                COMPONENT_SUPPORT = true;
                return COMPONENT_SUPPORT;
            }
            COMPONENT_SUPPORT = false;
            return COMPONENT_SUPPORT;
        }
        catch (ClassCastException | NoClassDefFoundError | ReflectiveOperationException ex) {
            COMPONENT_SUPPORT = false;
            return COMPONENT_SUPPORT;
        }
    }

    public static boolean hasPaperPluginSupport() {
        if (PAPER_PLUGIN_SUPPORT != null) {
            return PAPER_PLUGIN_SUPPORT;
        }
        int minorVersion = VersionUtility.getMinorVersion();
        if (minorVersion < 19) {
            PAPER_PLUGIN_SUPPORT = false;
            return PAPER_PLUGIN_SUPPORT;
        }
        try {
            Class.forName("io.papermc.paper.plugin.loader.PluginLoader");
            PAPER_PLUGIN_SUPPORT = true;
            return PAPER_PLUGIN_SUPPORT;
        }
        catch (ClassCastException | NoClassDefFoundError | ReflectiveOperationException ex) {
            PAPER_PLUGIN_SUPPORT = false;
            return PAPER_PLUGIN_SUPPORT;
        }
    }
}

