/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.utility;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

public final class VersionUtility {
    @NotNull
    public static String getMinecraftVersion() {
        try {
            return VersionUtility.getNewMinecraftVersion();
        }
        catch (ReflectiveOperationException ex) {
            String bukkitVersion = Bukkit.getBukkitVersion();
            int firstDash = bukkitVersion.indexOf(45);
            return bukkitVersion.substring(0, firstDash);
        }
    }

    @NotNull
    public static String getNewMinecraftVersion() throws ReflectiveOperationException {
        Server server = Bukkit.getServer();
        Class serverClass = server.getClass();
        Method method_getMinecraftVersion = serverClass.getMethod("getMinecraftVersion", new Class[0]);
        return (String)method_getMinecraftVersion.invoke((Object)server, new Object[0]);
    }

    @NotNull
    public static String getNetMinecraftServerVersion() {
        try {
            String newMinecraftVersion = VersionUtility.getNewMinecraftVersion();
            return VersionUtility.getNmsVersion(newMinecraftVersion);
        }
        catch (ReflectiveOperationException ex) {
            Server server = Bukkit.getServer();
            Class serverClass = server.getClass();
            Package serverPackage = serverClass.getPackage();
            String serverPackageName = serverPackage.getName();
            int lastPeriodIndex = serverPackageName.lastIndexOf(46);
            int nextIndex = lastPeriodIndex + 2;
            return serverPackageName.substring(nextIndex);
        }
    }

    @NotNull
    private static String getNmsVersion(@NotNull String version) {
        switch (version) {
            case "1.16": 
            case "1.16.1": {
                return "1_16_R1";
            }
            case "1.16.2": 
            case "1.16.3": {
                return "1_16_R2";
            }
            case "1.16.4": 
            case "1.16.5": {
                return "1_16_R3";
            }
            case "1.17": 
            case "1.17.1": {
                return "1_17_R1";
            }
            case "1.18": 
            case "1.18.1": {
                return "1_18_R1";
            }
            case "1.18.2": {
                return "1_18_R2";
            }
            case "1.19": 
            case "1.19.1": 
            case "1.19.2": {
                return "1_19_R1";
            }
            case "1.19.3": {
                return "1_19_R2";
            }
            case "1.19.4": {
                return "1_19_R3";
            }
            case "1.20": 
            case "1.20.1": {
                return "1_20_R1";
            }
            case "1.20.2": {
                return "1_20_R2";
            }
            case "1.20.3": 
            case "1.20.4": {
                return "1_20_R3";
            }
            case "1.20.5": 
            case "1.20.6": {
                return "1_20_R4";
            }
            case "1.21": 
            case "1.21.1": {
                return "1_21_R1";
            }
            case "1.21.2": 
            case "1.21.3": {
                return "1_21_R2";
            }
            case "1.21.4": {
                return "1_21_R3";
            }
            case "1.21.5": {
                return "1_21_R4";
            }
            case "1.21.6": 
            case "1.21.7": 
            case "1.21.8": {
                return "1_21_R5";
            }
            case "1.21.9": 
            case "1.21.10": {
                return "1_21_R6";
            }
        }
        return "Unsupported";
    }

    @NotNull
    public static String getMajorMinorVersion() {
        String minecraftVersion = VersionUtility.getMinecraftVersion();
        int lastPeriodIndex = minecraftVersion.lastIndexOf(46);
        return lastPeriodIndex < 2 ? minecraftVersion : minecraftVersion.substring(0, lastPeriodIndex);
    }

    public static int getMajorVersion() {
        String majorMinorVersion = VersionUtility.getMajorMinorVersion();
        int periodIndex = majorMinorVersion.indexOf(46);
        String majorString = majorMinorVersion.substring(0, periodIndex);
        return Integer.parseInt(majorString);
    }

    public static int getMinorVersion() {
        String majorMinorVersion = VersionUtility.getMajorMinorVersion();
        int periodIndex = majorMinorVersion.indexOf(46);
        int nextIndex = periodIndex + 1;
        String minorString = majorMinorVersion.substring(nextIndex);
        return Integer.parseInt(minorString);
    }

    static {
        String bukkitVersion = Bukkit.getBukkitVersion();
        if (bukkitVersion.contains("-pre") || bukkitVersion.contains("-rc")) {
            Logger logger = Bukkit.getLogger();
            logger.warning("[BlueSlimeCore] You are using a '-pre' or '-rc' version of spigot.");
            logger.warning("[BlueSlimeCore] Bugs may occur when using a preview version.");
        }
    }
}

