/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public final class MessageUtility {
    @NotNull
    public static String color(@NotNull String message) {
        try {
            Class.forName("net.md_5.bungee.api.ChatColor");
            return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
        catch (ReflectiveOperationException ex) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
    }

    public static String @NotNull [] colorArray(String ... messageArray) {
        int messageArrayLength = messageArray.length;
        String[] colorMessageArray = new String[messageArrayLength];
        for (int i = 0; i < messageArrayLength; ++i) {
            String message = messageArray[i];
            colorMessageArray[i] = MessageUtility.color(message);
        }
        return colorMessageArray;
    }

    @NotNull
    public static List<String> colorList(@NotNull Iterable<String> messageList) {
        ArrayList<String> colorList = new ArrayList<String>();
        for (String message : messageList) {
            String color = MessageUtility.color(message);
            colorList.add(color);
        }
        return colorList;
    }

    @NotNull
    public static List<String> colorList(String ... messageArray) {
        List<String> messageList = Arrays.asList(messageArray);
        return MessageUtility.colorList(messageList);
    }

    @NotNull
    public static List<String> getMatches(@NotNull String token, @NotNull Iterable<String> originals) {
        ArrayList<String> collection = new ArrayList<String>();
        for (String string : originals) {
            if (!MessageUtility.startsWithIgnoreCase(string, token)) continue;
            collection.add(string);
        }
        return collection;
    }

    public static boolean startsWithIgnoreCase(@NotNull String string, @NotNull String prefix) {
        if (string.length() < prefix.length()) {
            return false;
        }
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

