/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.utility;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemUtility {
    @Contract(value="null -> true")
    public static boolean isAir(@Nullable ItemStack item) {
        if (item == null) {
            return true;
        }
        Material material = item.getType();
        String materialName = material.name();
        List<String> airList = Arrays.asList("AIR", "CAVE_AIR", "VOID_AIR");
        return airList.contains(materialName);
    }

    @NotNull
    public static ItemStack getAir() {
        return new ItemStack(Material.AIR);
    }

    @Contract(value="null -> false")
    public static boolean hasItemMeta(@Nullable ItemStack item) {
        if (ItemUtility.isAir(item)) {
            return false;
        }
        return item.hasItemMeta();
    }

    @Contract(value="null -> false")
    public static boolean hasDisplayName(@Nullable ItemStack item) {
        if (!ItemUtility.hasItemMeta(item)) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        return itemMeta.hasDisplayName();
    }

    @Contract(value="null -> false")
    public static boolean hasLore(@Nullable ItemStack item) {
        if (!ItemUtility.hasItemMeta(item)) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        return itemMeta.hasLore();
    }

    @Contract(value="null,_ -> false")
    public static boolean doesAnyLoreContain(@Nullable ItemStack item, @NotNull String query) {
        if (!ItemUtility.hasLore(item)) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        List loreList = itemMeta.getLore();
        if (loreList == null || loreList.isEmpty()) {
            return false;
        }
        for (String line : loreList) {
            if (!line.contains(query)) continue;
            return true;
        }
        return false;
    }
}

