/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.utility;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class ExperienceUtility {
    public static int getExp(@NotNull Player player) {
        int playerLevel = player.getLevel();
        float playerExp = player.getExp();
        int round = Math.round((float)ExperienceUtility.getExpToNext(playerLevel) * playerExp);
        return round + ExperienceUtility.getExpFromLevel(playerLevel);
    }

    public static int getExpFromLevel(int level) {
        if (level > 30) {
            return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        if (level > 15) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return level * level + 6 * level;
    }

    public static double getLevelFromExp(long exp) {
        if (exp > 1395L) {
            return (Math.sqrt(72L * exp - 54215L) + 325.0) / 18.0;
        }
        if (exp > 315L) {
            return Math.sqrt(40L * exp - 7839L) / 10.0 + 8.1;
        }
        if (exp > 0L) {
            return Math.sqrt(exp + 9L) - 3.0;
        }
        return 0.0;
    }

    private static int getExpToNext(int level) {
        if (level > 30) {
            return 9 * level - 158;
        }
        if (level > 15) {
            return 5 * level - 38;
        }
        return 2 * level + 7;
    }

    public static void changeExp(@NotNull Player player, int exp) {
        if ((exp += ExperienceUtility.getExp(player)) < 0) {
            exp = 0;
        }
        double levelAndExp = ExperienceUtility.getLevelFromExp(exp);
        int level = (int)levelAndExp;
        player.setLevel(level);
        player.setExp((float)(levelAndExp - (double)level));
    }
}

