/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.utility;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationHelper {
    @Contract(value="_, _, !null -> !null")
    public static <E extends Enum<E>> E parseEnum(@NotNull Class<E> enumClass, @NotNull String value, @Nullable E defaultValue) {
        Enum[] enumValues;
        String uppercaseValue = value.toUpperCase(Locale.US);
        String fixedValue = uppercaseValue.replace(' ', '_').replace('-', '_');
        for (Enum enumValue : enumValues = (Enum[])enumClass.getEnumConstants()) {
            String enumName = enumValue.name();
            if (!enumName.equals(fixedValue)) continue;
            return (E)enumValue;
        }
        return defaultValue;
    }

    @NotNull
    public static <E extends Enum<E>> Set<E> parseEnums(@NotNull Collection<String> items, @NotNull Class<E> enumClass) {
        if (items.isEmpty()) {
            return EnumSet.noneOf(enumClass);
        }
        if (items.contains("*")) {
            return EnumSet.allOf(enumClass);
        }
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        EnumSet<Enum> enumSet = EnumSet.noneOf(enumClass);
        for (Enum enumValue : enumValues) {
            String enumName = enumValue.name();
            if (!items.contains(enumName)) continue;
            enumSet.add(enumValue);
        }
        return enumSet;
    }

    @NotNull
    public static <E extends Enum<E>> Set<String> getEnumNames(@NotNull Class<E> enumClass) {
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        HashSet<String> enumNameSet = new HashSet<String>();
        for (Enum enumValue : enumArray) {
            String enumName = enumValue.name();
            enumNameSet.add(enumName);
        }
        return Collections.unmodifiableSet(enumNameSet);
    }
}

