/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.update;

import com.github.sirblobman.api.folia.FoliaHelper;
import com.github.sirblobman.api.folia.FoliaPlugin;
import com.github.sirblobman.api.folia.details.TaskDetails;
import com.github.sirblobman.api.folia.scheduler.TaskScheduler;
import com.github.sirblobman.api.update.HangarInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HangarUpdateManager {
    private static final String BASE_API_URL = "https://hangar.papermc.io/api/v1/projects/%s/%s/latestrelease";
    private static final String BASE_RESOURCE_URL = "https://hangar.papermc.io/%s/%s";
    private final FoliaPlugin plugin;
    private final Map<String, HangarInfo> pluginInfoMap;
    private final Map<String, String> hangarVersionCache;

    public HangarUpdateManager(@NotNull FoliaPlugin plugin) {
        this.plugin = plugin;
        this.pluginInfoMap = new HashMap<String, HangarInfo>();
        this.hangarVersionCache = new HashMap<String, String>();
    }

    public void addProject(@NotNull Plugin plugin, @NotNull HangarInfo hangarInfo) {
        String pluginName = plugin.getName();
        this.pluginInfoMap.put(pluginName, hangarInfo);
    }

    public void removeProject(@NotNull Plugin plugin) {
        String pluginName = plugin.getName();
        this.pluginInfoMap.remove(pluginName);
    }

    @Nullable
    public String getCachedHangarVersion(@NotNull Plugin plugin) {
        String pluginName = plugin.getName();
        return this.hangarVersionCache.get(pluginName);
    }

    public void checkForUpdates() {
        if (!this.isEnabled()) {
            this.printDisabledInformation();
            return;
        }
        FoliaPlugin plugin = this.getPlugin();
        TaskDetails task = new TaskDetails(plugin.getPlugin()){

            @Override
            public void run() {
                HangarUpdateManager.this.fetchUpdates();
            }
        };
        FoliaHelper foliaHelper = plugin.getFoliaHelper();
        TaskScheduler scheduler = foliaHelper.getScheduler();
        scheduler.scheduleAsyncTask(task);
    }

    @NotNull
    private FoliaPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    private Logger getLogger() {
        Plugin plugin = this.getPlugin().getPlugin();
        return plugin.getLogger();
    }

    private boolean isEnabled() {
        Plugin plugin = this.getPlugin().getPlugin();
        FileConfiguration configuration = plugin.getConfig();
        return configuration.getBoolean("update-checker", false);
    }

    private void printDisabledInformation() {
        Logger logger = this.getLogger();
        logger.info("[Update Checker] The update checking feature is disabled.");
        logger.info("[Update Checker] No plugin update information is available.");
    }

    private void fetchUpdates() {
        this.fetchHangarVersions();
        this.printUpdateInformation();
    }

    private void fetchHangarVersions() {
        Set<String> pluginNameSet = this.pluginInfoMap.keySet();
        for (String pluginName : pluginNameSet) {
            this.fetchHangarVersion(pluginName);
        }
    }

    @NotNull
    private HangarInfo getHangarInfo(@NotNull String pluginName) {
        return this.pluginInfoMap.get(pluginName);
    }

    private void fetchHangarVersion(@NotNull String pluginName) {
        HangarInfo hangarInfo = this.getHangarInfo(pluginName);
        String authorName = hangarInfo.getAuthor();
        String projectName = hangarInfo.getProject();
        try {
            String updateUrlString = String.format(Locale.US, BASE_API_URL, authorName, projectName);
            URL updateUrl = URI.create(updateUrlString).toURL();
            this.fetchHangarVersion(pluginName, updateUrl);
        }
        catch (MalformedURLException ex) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Invalid Update Check URL:", ex);
        }
    }

    private void fetchHangarVersion(@NotNull String pluginName, @NotNull URL updateUrl) {
        try {
            URLConnection connection = updateUrl.openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                throw new IOException("URL is not using 'http/https'.");
            }
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setRequestMethod("GET");
            this.fetchHangarVersion(pluginName, httpConnection);
        }
        catch (IOException ex) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Failed to start an HTTP/HTTPS connection:", ex);
        }
    }

    private void fetchHangarVersion(@NotNull String pluginName, @NotNull HttpURLConnection connection) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String hangarVersion = reader.readLine();
            this.hangarVersionCache.put(pluginName, hangarVersion);
        }
        catch (IOException ex) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Failed to fetch update data:", ex);
        }
    }

    private void printUpdateInformation() {
        Set<Map.Entry<String, HangarInfo>> entrySet = this.pluginInfoMap.entrySet();
        for (Map.Entry<String, HangarInfo> entry : entrySet) {
            String pluginName = entry.getKey();
            HangarInfo info = entry.getValue();
            String version = this.hangarVersionCache.get(pluginName);
            this.printUpdateInformation(pluginName, version, info);
        }
    }

    private void printUpdateInformation(@NotNull String pluginName, @Nullable String version, @NotNull HangarInfo info) {
        PluginManager pluginManager = Bukkit.getPluginManager();
        Plugin plugin = pluginManager.getPlugin(pluginName);
        if (plugin == null) {
            return;
        }
        PluginDescriptionFile description = plugin.getDescription();
        String pluginVersion = description.getVersion();
        Logger logger = plugin.getLogger();
        logger.info(" ");
        if (version == null) {
            this.printFailedInformation(pluginName, logger);
            return;
        }
        if (pluginVersion.equals(version)) {
            this.printSameVersion(pluginName, logger);
            return;
        }
        this.printMismatch(pluginName, logger, pluginVersion, version, info);
    }

    private void printFailedInformation(@NotNull String pluginName, @NotNull Logger logger) {
        logger.info("[Update Checker] Update check failed for plugin '" + pluginName + "'.");
        logger.info("[Update Checker] Is is possible that your server does not have access to the internet.");
    }

    private void printSameVersion(@NotNull String pluginName, @NotNull Logger logger) {
        logger.info("[Update Checker] There are no updates available for plugin '" + pluginName + "'.");
    }

    private void printMismatch(@NotNull String pluginName, @NotNull Logger logger, @NotNull String localVersion, @NotNull String remoteVersion, @NotNull HangarInfo info) {
        logger.info("[Update Checker] Found a possible update for plugin '" + pluginName + "'.");
        logger.info("[Update Checker] Local Version: " + localVersion);
        logger.info("[Update Checker] Remote Version: " + remoteVersion);
        String downloadUrl = String.format(BASE_RESOURCE_URL, info.getAuthor(), info.getProject());
        logger.info("[Update Checker] Download Link: " + downloadUrl);
    }
}

