/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.shaded.xseries.reflection;

import com.github.sirblobman.api.shaded.xseries.reflection.jvm.classes.ClassHandle;
import com.github.sirblobman.api.shaded.xseries.reflection.jvm.classes.DynamicClassHandle;
import com.github.sirblobman.api.shaded.xseries.reflection.jvm.classes.StaticClassHandle;
import com.github.sirblobman.api.shaded.xseries.reflection.minecraft.MinecraftClassHandle;
import com.github.sirblobman.api.shaded.xseries.reflection.parser.ReflectionParser;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ReflectiveNamespace {
    private final Map<String, Class<?>> imports = new HashMap();
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final Set<ClassHandle> handles = Collections.newSetFromMap(new IdentityHashMap());

    protected ReflectiveNamespace() {
    }

    public ReflectiveNamespace imports(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.imports(clazz.getSimpleName(), clazz);
        }
        return this;
    }

    public ReflectiveNamespace imports(@NotNull String name, @NotNull Class<?> clazz) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(clazz);
        this.imports.put(name, clazz);
        return this;
    }

    @NotNull
    @ApiStatus.Internal
    public Map<String, Class<?>> getImports() {
        for (ClassHandle handle : this.handles) {
            Class clazz = (Class)handle.reflectOrNull();
            if (clazz == null) continue;
            for (String className : handle.getPossibleNames()) {
                this.imports.put(className, clazz);
            }
        }
        return this.imports;
    }

    @ApiStatus.Internal
    public void link(ClassHandle handle) {
        if (handle.getNamespace() != this) {
            throw new IllegalArgumentException("Not the same namespace");
        }
        this.handles.add(handle);
    }

    @NotNull
    @ApiStatus.Internal
    public MethodHandles.Lookup getLookup() {
        return this.lookup;
    }

    public StaticClassHandle of(Class<?> clazz) {
        this.imports(clazz);
        return new StaticClassHandle(this, clazz);
    }

    public DynamicClassHandle classHandle(@Language(value="Java", suffix="{}") String declaration) {
        DynamicClassHandle classHandle = new DynamicClassHandle(this);
        return new ReflectionParser(declaration).imports(this).parseClass(classHandle);
    }

    public DynamicClassHandle classHandle() {
        return new DynamicClassHandle(this);
    }

    public MinecraftClassHandle ofMinecraft(@Language(value="Java", suffix="{}") String declaration) {
        MinecraftClassHandle classHandle = new MinecraftClassHandle(this);
        return new ReflectionParser(declaration).imports(this).parseClass(classHandle);
    }

    public MinecraftClassHandle ofMinecraft() {
        return new MinecraftClassHandle(this);
    }
}

