/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.shaded.xseries.profiles.objects.transformer;

import com.github.sirblobman.api.shaded.xseries.profiles.PlayerProfiles;
import com.github.sirblobman.api.shaded.xseries.profiles.gameprofile.MojangGameProfile;
import com.github.sirblobman.api.shaded.xseries.profiles.objects.Profileable;
import com.mojang.authlib.properties.Property;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProfileTransformer {
    @NotNull
    public MojangGameProfile transform(@NotNull Profileable var1, @NotNull MojangGameProfile var2);

    @ApiStatus.Internal
    public boolean canBeCached();

    @NotNull
    public static ProfileTransformer stackable() {
        return RemoveMetadata.INSTANCE;
    }

    @NotNull
    public static ProfileTransformer nonStackable() {
        return MakeNotStackable.INSTANCE;
    }

    @NotNull
    public static ProfileTransformer removeMetadata() {
        return RemoveMetadata.INSTANCE;
    }

    @NotNull
    public static ProfileTransformer includeOriginalValue() {
        return IncludeOriginalValue.INSTANCE;
    }

    public static final class RemoveMetadata
    implements ProfileTransformer {
        private static final RemoveMetadata INSTANCE = new RemoveMetadata();

        @Override
        public MojangGameProfile transform(Profileable profileable, MojangGameProfile profile) {
            PlayerProfiles.removeTimestamp(profile);
            return profile.copy(x -> {
                x.removeProperty("XSeries");
                x.removeProperty("OriginalValue");
            });
        }

        @Override
        public boolean canBeCached() {
            return true;
        }
    }

    public static final class MakeNotStackable
    implements ProfileTransformer {
        private static final MakeNotStackable INSTANCE = new MakeNotStackable();
        private static final String PROPERTY_NAME = "XSeriesSeed";
        private static final AtomicLong NEXT_ID = new AtomicLong();

        @Override
        public MojangGameProfile transform(Profileable profileable, MojangGameProfile profile) {
            String value = System.currentTimeMillis() + "-" + NEXT_ID.getAndIncrement();
            return profile.copy(x -> x.setProperty(PROPERTY_NAME, value));
        }

        @Override
        public boolean canBeCached() {
            return false;
        }
    }

    public static final class IncludeOriginalValue
    implements ProfileTransformer {
        private static final IncludeOriginalValue INSTANCE = new IncludeOriginalValue();
        public static final String PROPERTY_NAME = "OriginalValue";

        @Nullable
        public static String getOriginalValue(@NotNull MojangGameProfile profile) {
            Property prop = profile.getProperty(PROPERTY_NAME);
            if (prop == null) {
                return null;
            }
            return PlayerProfiles.getPropertyValue(prop);
        }

        @Override
        public MojangGameProfile transform(Profileable profileable, MojangGameProfile profile) {
            String originalValue = profileable.getProfileValue();
            return profile.copy(x -> x.setProperty(PROPERTY_NAME, originalValue));
        }

        @Override
        public boolean canBeCached() {
            return true;
        }
    }
}

