/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.plugin;

import com.github.sirblobman.api.configuration.ConfigurationManager;
import com.github.sirblobman.api.configuration.PlayerDataManager;
import com.github.sirblobman.api.folia.FoliaHelper;
import com.github.sirblobman.api.language.LanguageManager;
import com.github.sirblobman.api.nms.MultiVersionHandler;
import com.github.sirblobman.api.plugin.IMultiVersionPlugin;
import java.util.Locale;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurablePlugin
extends JavaPlugin
implements IMultiVersionPlugin {
    private final ConfigurationManager configurationManager = new ConfigurationManager((Plugin)this);
    private final MultiVersionHandler multiVersionHandler = new MultiVersionHandler(this);
    private final PlayerDataManager playerDataManager = new PlayerDataManager((Plugin)this);
    private final LanguageManager languageManager = new LanguageManager(this.configurationManager);
    private final FoliaHelper foliaHelper = new FoliaHelper((Plugin)this);

    public abstract void onLoad();

    public abstract void onEnable();

    public abstract void onDisable();

    public final void saveDefaultConfig() {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        configurationManager.saveDefault("config.yml");
    }

    public final void saveConfig() {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        configurationManager.save("config.yml");
    }

    public final void reloadConfig() {
        this.reloadConfiguration();
    }

    @NotNull
    public final YamlConfiguration getConfig() {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        return configurationManager.get("config.yml");
    }

    @NotNull
    public ConfigurablePlugin getPlugin() {
        return this;
    }

    @Override
    @NotNull
    public FoliaHelper getFoliaHelper() {
        return this.foliaHelper;
    }

    protected void reloadConfiguration() {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        configurationManager.reload("config.yml");
    }

    @NotNull
    public final ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    @Override
    @NotNull
    public final MultiVersionHandler getMultiVersionHandler() {
        return this.multiVersionHandler;
    }

    @NotNull
    public final PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    @NotNull
    public final LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public boolean isDebugMode() {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        YamlConfiguration configuration = configurationManager.get("config.yml");
        return configuration.getBoolean("debug-mode", false);
    }

    public void printDebug(@NotNull String message) {
        if (this.isDebugMode()) {
            Logger logger = this.getLogger();
            String logMessage = String.format(Locale.US, "[Debug] %s", message);
            logger.info(logMessage);
        }
    }
}

