/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms.scoreboard;

import com.github.sirblobman.api.nms.Handler;
import com.github.sirblobman.api.utility.VersionUtility;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;

public final class ScoreboardHandler
extends Handler {
    public ScoreboardHandler(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @NotNull
    public Objective createObjective(@NotNull Scoreboard scoreboard, @NotNull String name, @NotNull String criteria, @NotNull String displayName) {
        int minorVersion = VersionUtility.getMinorVersion();
        if (minorVersion < 13) {
            return this.createObjectiveLegacy(scoreboard, name, criteria, displayName);
        }
        return this.createObjectiveModern(scoreboard, name, criteria, displayName);
    }

    @NotNull
    private Objective createObjectiveLegacy(@NotNull Scoreboard scoreboard, @NotNull String name, @NotNull String criteria, @NotNull String displayName) {
        Objective objective = scoreboard.registerNewObjective(name, criteria);
        objective.setDisplayName(displayName);
        return objective;
    }

    @NotNull
    private Objective createObjectiveModern(@NotNull Scoreboard scoreboard, @NotNull String name, @NotNull String criteria, @NotNull String displayName) {
        return scoreboard.registerNewObjective(name, criteria, displayName);
    }
}

