/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.bossbar.BossBarHandler;
import com.github.sirblobman.api.nms.EntityHandler;
import com.github.sirblobman.api.nms.EntityHandler_Paper;
import com.github.sirblobman.api.nms.HeadHandler;
import com.github.sirblobman.api.nms.HeadHandler_Paper;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.nms.ItemHandler_Paper;
import com.github.sirblobman.api.nms.PlayerHandler;
import com.github.sirblobman.api.nms.PlayerHandler_Paper;
import com.github.sirblobman.api.nms.ServerHandler;
import com.github.sirblobman.api.nms.ServerHandler_Paper;
import com.github.sirblobman.api.nms.scoreboard.ScoreboardHandler;
import com.github.sirblobman.api.utility.VersionUtility;
import com.github.sirblobman.api.utility.paper.PaperChecker;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class MultiVersionHandler {
    private final JavaPlugin plugin;
    private BossBarHandler bossBarHandler;
    private ScoreboardHandler scoreboardHandler;
    private EntityHandler entityHandler;
    private HeadHandler headHandler;
    private ItemHandler itemHandler;
    private PlayerHandler playerHandler;
    private ServerHandler serverHandler;

    public MultiVersionHandler(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    private Class<?> findHandlerClass(@NotNull String classType, @NotNull String nmsVersion) throws ReflectiveOperationException {
        Class<?> thisClass = this.getClass();
        Package thisPackage = thisClass.getPackage();
        String packageName = thisPackage.getName();
        JavaPlugin plugin = this.getPlugin();
        Logger logger = plugin.getLogger();
        String className = String.format(Locale.US, "%s.%s_%s", packageName, classType, nmsVersion);
        try {
            logger.info("Searching for class named '" + className + "'.");
            return Class.forName(className);
        }
        catch (NoClassDefFoundError ex) {
            logger.log(Level.WARNING, "Failed to find class '" + className + "'.");
            logger.log(Level.WARNING, "Original error:", ex);
            throw new IllegalStateException(ex);
        }
    }

    @NotNull
    private <O> O convertClass(@NotNull Class<O> typeClass, Class<?> preClass) throws ReflectiveOperationException {
        JavaPlugin plugin = this.getPlugin();
        Class<O> subClass = preClass.asSubclass(typeClass);
        Constructor<O> constructor = subClass.getDeclaredConstructor(JavaPlugin.class);
        return constructor.newInstance(plugin);
    }

    @NotNull
    private <O> O getHandler(@NotNull Class<O> typeClass, @NotNull String classType) {
        JavaPlugin plugin = this.getPlugin();
        String nmsVersion = VersionUtility.getNetMinecraftServerVersion();
        try {
            Class<?> handlerClass = this.findHandlerClass(classType, nmsVersion);
            return this.convertClass(typeClass, handlerClass);
        }
        catch (ReflectiveOperationException ex) {
            Logger logger = plugin.getLogger();
            logger.warning("Failed to find handler class with type '" + String.valueOf(typeClass) + "'.");
            logger.warning("Possibly missing support for NMS version '" + nmsVersion + "'.");
            logger.warning("Searching for fallback handler...");
            try {
                Class<?> handlerClass = this.findHandlerClass(classType, "Fallback");
                return this.convertClass(typeClass, handlerClass);
            }
            catch (ReflectiveOperationException ex2) {
                logger.log(Level.WARNING, "Failed to find fallback class with type '" + String.valueOf(typeClass) + "'.");
                logger.log(Level.WARNING, "Original error that caused fallback search:", ex);
                throw new IllegalStateException(ex2);
            }
        }
    }

    @NotNull
    public BossBarHandler getBossBarHandler() {
        if (this.bossBarHandler == null) {
            JavaPlugin plugin = this.getPlugin();
            this.bossBarHandler = new BossBarHandler(plugin);
        }
        return this.bossBarHandler;
    }

    @NotNull
    public ScoreboardHandler getScoreboardHandler() {
        if (this.scoreboardHandler == null) {
            JavaPlugin plugin = this.getPlugin();
            this.scoreboardHandler = new ScoreboardHandler(plugin);
        }
        return this.scoreboardHandler;
    }

    @NotNull
    public EntityHandler getEntityHandler() {
        if (this.entityHandler != null) {
            return this.entityHandler;
        }
        if (PaperChecker.isPaper() && PaperChecker.hasNativeComponentSupport()) {
            JavaPlugin plugin = this.getPlugin();
            this.entityHandler = new EntityHandler_Paper(plugin);
            return this.entityHandler;
        }
        this.entityHandler = this.getHandler(EntityHandler.class, "EntityHandler");
        return this.entityHandler;
    }

    @NotNull
    public PlayerHandler getPlayerHandler() {
        if (this.playerHandler != null) {
            return this.playerHandler;
        }
        if (PaperChecker.isPaper() && PaperChecker.hasNativeComponentSupport()) {
            JavaPlugin plugin = this.getPlugin();
            this.playerHandler = new PlayerHandler_Paper(plugin);
            return this.playerHandler;
        }
        this.playerHandler = this.getHandler(PlayerHandler.class, "PlayerHandler");
        return this.playerHandler;
    }

    @NotNull
    public HeadHandler getHeadHandler() {
        if (this.headHandler != null) {
            return this.headHandler;
        }
        if (PaperChecker.isPaper() && PaperChecker.hasNativeComponentSupport()) {
            JavaPlugin plugin = this.getPlugin();
            this.headHandler = new HeadHandler_Paper(plugin);
            return this.headHandler;
        }
        this.headHandler = this.getHandler(HeadHandler.class, "HeadHandler");
        return this.headHandler;
    }

    @NotNull
    public ItemHandler getItemHandler() {
        if (this.itemHandler != null) {
            return this.itemHandler;
        }
        ItemHandler nmsItemHandler = this.getHandler(ItemHandler.class, "ItemHandler");
        if (PaperChecker.isPaper() && PaperChecker.hasNativeComponentSupport()) {
            JavaPlugin plugin = this.getPlugin();
            this.itemHandler = new ItemHandler_Paper(plugin, nmsItemHandler);
            return this.itemHandler;
        }
        this.itemHandler = nmsItemHandler;
        return this.itemHandler;
    }

    @NotNull
    public ServerHandler getServerHandler() {
        if (this.serverHandler != null) {
            return this.serverHandler;
        }
        if (PaperChecker.isPaper() && PaperChecker.hasNativeComponentSupport()) {
            JavaPlugin plugin = this.getPlugin();
            this.serverHandler = new ServerHandler_Paper(plugin);
            return this.serverHandler;
        }
        this.serverHandler = this.getHandler(ServerHandler.class, "ServerHandler");
        return this.serverHandler;
    }
}

