/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.language.ComponentHelper;
import com.github.sirblobman.api.nbt.CustomNbtContainer;
import com.github.sirblobman.api.nbt.modern.CustomNbtPersistentDataContainerWrapper;
import com.github.sirblobman.api.nbt.modern.PersistentDataConverter;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.utility.Validate;
import com.github.sirblobman.api.utility.paper.ComponentConverter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHandler_Paper
extends ItemHandler {
    private final ItemHandler backup;

    public ItemHandler_Paper(@NotNull JavaPlugin plugin, @NotNull ItemHandler backup) {
        super(plugin);
        this.backup = backup;
        Logger logger = this.getLogger();
        logger.info("Using Paper ItemHandler with NMS backup for NBT.");
    }

    @NotNull
    private ItemHandler getBackup() {
        return this.backup;
    }

    @Override
    @NotNull
    public String getLocalizedName(@NotNull ItemStack item) {
        net.kyori.adventure.text.Component paperDisplayName;
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null && itemMeta.hasDisplayName() && (paperDisplayName = itemMeta.displayName()) != null) {
            Component displayName = ComponentConverter.normalToShaded(paperDisplayName);
            return ComponentHelper.toPlain(displayName);
        }
        String languageName = item.getI18NDisplayName();
        return languageName != null ? languageName : item.getTranslationKey();
    }

    @Override
    @NotNull
    public String getKeyString(@NotNull ItemStack item) {
        Material material = item.getType();
        NamespacedKey key = material.getKey();
        return key.toString();
    }

    @Override
    @NotNull
    public String toNBT(@NotNull ItemStack item) {
        ItemHandler backup = this.getBackup();
        return backup.toNBT(item);
    }

    @Override
    @NotNull
    public ItemStack fromNBT(@NotNull String string) {
        ItemHandler backup = this.getBackup();
        return backup.fromNBT(string);
    }

    @Override
    @NotNull
    public String toBase64String(@NotNull ItemStack item) {
        byte[] itemBytes = item.serializeAsBytes();
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(itemBytes);
    }

    @Override
    @NotNull
    public ItemStack fromBase64String(@NotNull String string) {
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] byteArray = decoder.decode(string);
            return ItemStack.deserializeBytes((byte[])byteArray);
        }
        catch (Exception ex) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Failed to encode an item from a string:", ex);
            logger.warning("The item will be loaded as air.");
            return new ItemStack(Material.AIR);
        }
    }

    @Override
    @NotNull
    public CustomNbtContainer createNewCustomNbtContainer() {
        ItemStack item = new ItemStack(Material.BARRIER);
        return this.getCustomNbt(item);
    }

    @Override
    @NotNull
    public CustomNbtContainer getCustomNbt(@NotNull ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return this.createNewCustomNbtContainer();
        }
        JavaPlugin plugin = this.getPlugin();
        PersistentDataContainer dataContainer = this.createNBT(item);
        return PersistentDataConverter.convertContainer((Plugin)plugin, dataContainer);
    }

    @Override
    @NotNull
    public ItemStack setCustomNbt(@NotNull ItemStack item, @NotNull CustomNbtContainer container) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return item;
        }
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        if (container instanceof CustomNbtPersistentDataContainerWrapper) {
            CustomNbtPersistentDataContainerWrapper wrapper = (CustomNbtPersistentDataContainerWrapper)container;
            PersistentDataContainer internalContainer = wrapper.getContainer();
            JavaPlugin plugin = this.getPlugin();
            NamespacedKey pluginKey = new NamespacedKey((Plugin)plugin, plugin.getName().toLowerCase(Locale.US));
            dataContainer.set(pluginKey, PersistentDataType.TAG_CONTAINER, (Object)internalContainer);
        }
        item.setItemMeta(itemMeta);
        return item;
    }

    @NotNull
    private PersistentDataContainer createNBT(@NotNull ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        Validate.notNull(itemMeta, "item must not have null meta!");
        JavaPlugin plugin = this.getPlugin();
        String pluginName = plugin.getName().toLowerCase(Locale.US);
        NamespacedKey pluginKey = new NamespacedKey((Plugin)plugin, pluginName);
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        if (dataContainer.has(pluginKey, PersistentDataType.TAG_CONTAINER)) {
            PersistentDataContainer subContainer = (PersistentDataContainer)dataContainer.get(pluginKey, PersistentDataType.TAG_CONTAINER);
            return Validate.notNull(subContainer, "subContainer must not be null!");
        }
        PersistentDataAdapterContext context = dataContainer.getAdapterContext();
        PersistentDataContainer newContainer = context.newPersistentDataContainer();
        dataContainer.set(pluginKey, PersistentDataType.TAG_CONTAINER, (Object)newContainer);
        return newContainer;
    }

    @Override
    @Nullable
    public Component getDisplayName(@NotNull ItemStack item) {
        if (!item.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null || !itemMeta.hasDisplayName()) {
            return null;
        }
        net.kyori.adventure.text.Component paperDisplayName = itemMeta.displayName();
        if (paperDisplayName == null) {
            return null;
        }
        return ComponentConverter.normalToShaded(paperDisplayName);
    }

    @Override
    @NotNull
    public ItemStack setDisplayName(@NotNull ItemStack item, @Nullable Component displayName) {
        if (displayName == null) {
            item.editMeta(meta -> meta.displayName(null));
            return item;
        }
        net.kyori.adventure.text.Component paperDisplayName = ComponentConverter.shadedToNormal(displayName);
        item.editMeta(meta -> meta.displayName(paperDisplayName));
        return item;
    }

    @Override
    @Nullable
    public List<Component> getLore(@NotNull ItemStack item) {
        if (!item.hasItemMeta()) {
            return null;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null || !itemMeta.hasLore()) {
            return null;
        }
        List paperLore = itemMeta.lore();
        if (paperLore == null) {
            return null;
        }
        ArrayList<Component> lore = new ArrayList<Component>();
        for (net.kyori.adventure.text.Component paperLine : paperLore) {
            Component line = ComponentConverter.normalToShaded(paperLine);
            lore.add(line);
        }
        return lore;
    }

    @Override
    @NotNull
    public ItemStack setLore(@NotNull ItemStack item, @Nullable List<Component> lore) {
        if (lore == null) {
            item.editMeta(meta -> meta.lore(null));
            return item;
        }
        ArrayList<net.kyori.adventure.text.Component> paperLore = new ArrayList<net.kyori.adventure.text.Component>();
        for (Component line : lore) {
            net.kyori.adventure.text.Component paperLine = ComponentConverter.shadedToNormal(line);
            paperLore.add(paperLine);
        }
        item.editMeta(meta -> meta.lore(paperLore));
        return item;
    }
}

