/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.nbt.CustomNbtContainer;
import com.github.sirblobman.api.nbt.CustomNbtContainer_Fallback;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.xseries.XMaterial;
import com.github.sirblobman.api.utility.VersionUtility;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHandler_Fallback
extends ItemHandler {
    public ItemHandler_Fallback(@NotNull JavaPlugin plugin) {
        super(plugin);
        String minecraftVersion = VersionUtility.getMinecraftVersion();
        String nmsVersion = VersionUtility.getNetMinecraftServerVersion();
        Logger logger = this.getLogger();
        logger.warning("Using fallback ItemHandler.");
        logger.warning("Version '" + minecraftVersion + "' and NMS '" + nmsVersion + "' combo is not supported.");
        logger.warning("Please contact SirBlobman if you believe this is a mistake.");
        logger.warning("https://github.com/SirBlobman/BlueSlimeCore/issues/new/choose");
    }

    @Override
    @NotNull
    public String getLocalizedName(@NotNull ItemStack item) {
        XMaterial material = XMaterial.matchXMaterial(item);
        return material.toString();
    }

    @Override
    @NotNull
    public String getKeyString(@NotNull ItemStack item) {
        try {
            XMaterial material = XMaterial.matchXMaterial(item);
            return "minecraft:" + material.name();
        }
        catch (IllegalArgumentException ex) {
            return "N/A";
        }
    }

    @Override
    @NotNull
    public String toNBT(@NotNull ItemStack item) {
        return "{}";
    }

    @Override
    @NotNull
    public ItemStack fromNBT(@NotNull String string) {
        return new ItemStack(Material.AIR);
    }

    @Override
    @NotNull
    public String toBase64String(@NotNull ItemStack item) {
        return "";
    }

    @Override
    @NotNull
    public ItemStack fromBase64String(@NotNull String string) {
        return new ItemStack(Material.AIR);
    }

    @Override
    @NotNull
    public CustomNbtContainer createNewCustomNbtContainer() {
        JavaPlugin plugin = this.getPlugin();
        return new CustomNbtContainer_Fallback((Plugin)plugin);
    }

    @Override
    @NotNull
    public CustomNbtContainer getCustomNbt(@NotNull ItemStack item) {
        return this.createNewCustomNbtContainer();
    }

    @Override
    @NotNull
    public ItemStack setCustomNbt(@NotNull ItemStack item, @NotNull CustomNbtContainer container) {
        return item;
    }

    @Override
    @Nullable
    public Component getDisplayName(@NotNull ItemStack item) {
        return null;
    }

    @Override
    @NotNull
    public ItemStack setDisplayName(@NotNull ItemStack item, @Nullable Component displayName) {
        return item;
    }

    @Override
    @Nullable
    public List<Component> getLore(@NotNull ItemStack item) {
        return null;
    }

    @Override
    @NotNull
    public ItemStack setLore(@NotNull ItemStack item, @Nullable List<Component> lore) {
        return item;
    }
}

