/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.nbt.CustomNbtContainer;
import com.github.sirblobman.api.nbt.modern.CustomNbtPersistentDataContainerWrapper;
import com.github.sirblobman.api.nbt.modern.PersistentDataConverter;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.nms.ProblemReporter_1_21_R6;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.serializer.gson.GsonComponentSerializer;
import com.github.sirblobman.api.utility.Validate;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHandler_1_21_R6
extends ItemHandler {
    public ItemHandler_1_21_R6(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getLocalizedName(@NotNull ItemStack item) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        IChatBaseComponent hoverName = nmsItem.y();
        return CraftChatMessage.fromComponent((IChatBaseComponent)hoverName);
    }

    @Override
    @NotNull
    public String getKeyString(@NotNull ItemStack item) {
        NamespacedKey key;
        Material material = item.getType();
        if (material.isRegistered() && (key = material.getKeyOrNull()) != null) {
            return key.toString();
        }
        return "minecraft:air";
    }

    @Override
    @NotNull
    public String toNBT(@NotNull ItemStack item) {
        IRegistryCustom registry = CraftRegistry.getMinecraftRegistry();
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        JavaPlugin plugin = this.getPlugin();
        ProblemReporter_1_21_R6 problemReporter = new ProblemReporter_1_21_R6((Plugin)plugin);
        TagValueOutput tagValueOutput = TagValueOutput.a((ProblemReporter)problemReporter, (HolderLookup.a)registry);
        tagValueOutput.a("item", net.minecraft.world.item.ItemStack.b, (Object)nmsItem);
        NBTTagCompound output = tagValueOutput.b();
        NBTTagCompound tag = output.n("item");
        return tag.toString();
    }

    @Override
    @NotNull
    public ItemStack fromNBT(@NotNull String string) {
        try {
            NBTTagCompound tag = this.fixData(MojangsonParser.a((String)string));
            IRegistryCustom registry = CraftRegistry.getMinecraftRegistry();
            RegistryOps nbtOps = registry.a((DynamicOps)DynamicOpsNBT.a);
            DataResult decode = net.minecraft.world.item.ItemStack.b.decode((DynamicOps)nbtOps, (Object)tag);
            Pair pair = (Pair)decode.getOrThrow();
            net.minecraft.world.item.ItemStack nmsItem = (net.minecraft.world.item.ItemStack)pair.getFirst();
            return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
        }
        catch (CommandSyntaxException | NoSuchElementException ex) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Failed to parse an NBT string to an ItemStack:", ex);
            logger.warning("The item will be replaced with air.");
            return new ItemStack(Material.AIR);
        }
    }

    @Override
    @NotNull
    public String toBase64String(@NotNull ItemStack item) {
        String string;
        IRegistryCustom registry = CraftRegistry.getMinecraftRegistry();
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        JavaPlugin plugin = this.getPlugin();
        ProblemReporter_1_21_R6 problemReporter = new ProblemReporter_1_21_R6((Plugin)plugin);
        TagValueOutput tagValueOutput = TagValueOutput.a((ProblemReporter)problemReporter, (HolderLookup.a)registry);
        tagValueOutput.a("item", net.minecraft.world.item.ItemStack.b, (Object)nmsItem);
        NBTTagCompound output = tagValueOutput.b();
        NBTTagCompound tag = output.n("item");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)tag, (OutputStream)outputStream);
            byte[] byteArray = outputStream.toByteArray();
            Base64.Encoder encoder = Base64.getEncoder();
            string = encoder.encodeToString(byteArray);
        }
        catch (Throwable byteArray) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {
                    byteArray.addSuppressed(throwable);
                }
                throw byteArray;
            }
            catch (IOException ex) {
                Logger logger = this.getLogger();
                logger.log(Level.WARNING, "Failed to encode an item to a string:", ex);
                logger.warning("The item will not be saved properly.");
                return "";
            }
        }
        outputStream.close();
        return string;
    }

    @Override
    @NotNull
    public ItemStack fromBase64String(@NotNull String string) {
        ItemStack itemStack;
        if (string.isEmpty()) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Decoded an empty string to air.");
            return new ItemStack(Material.AIR);
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byteArray = decoder.decode(string);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        try {
            IRegistryCustom registry = CraftRegistry.getMinecraftRegistry();
            NBTReadLimiter unlimited = NBTReadLimiter.a();
            NBTTagCompound tag = NBTCompressedStreamTools.a((InputStream)inputStream, (NBTReadLimiter)unlimited);
            NBTTagCompound fixedTag = this.fixData(tag);
            RegistryOps nbtOps = registry.a((DynamicOps)DynamicOpsNBT.a);
            Codec codec = net.minecraft.world.item.ItemStack.b;
            DataResult decode = codec.decode((DynamicOps)nbtOps, (Object)fixedTag);
            Pair pair = (Pair)decode.getOrThrow();
            net.minecraft.world.item.ItemStack nmsItem = (net.minecraft.world.item.ItemStack)pair.getFirst();
            itemStack = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
        }
        catch (Throwable registry) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    registry.addSuppressed(throwable);
                }
                throw registry;
            }
            catch (IOException ex) {
                Logger logger = this.getLogger();
                logger.log(Level.WARNING, "Failed to encode an item from a string:", ex);
                logger.warning("The item will be loaded as air.");
                return new ItemStack(Material.AIR);
            }
        }
        inputStream.close();
        return itemStack;
    }

    @Override
    @NotNull
    public CustomNbtContainer createNewCustomNbtContainer() {
        ItemStack item = new ItemStack(Material.BARRIER);
        return this.getCustomNbt(item);
    }

    @Override
    @NotNull
    public CustomNbtContainer getCustomNbt(@NotNull ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return this.createNewCustomNbtContainer();
        }
        JavaPlugin plugin = this.getPlugin();
        PersistentDataContainer dataContainer = this.createNBT(item);
        return PersistentDataConverter.convertContainer((Plugin)plugin, dataContainer);
    }

    @Override
    @NotNull
    public ItemStack setCustomNbt(@NotNull ItemStack item, @NotNull CustomNbtContainer container) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return item;
        }
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        if (container instanceof CustomNbtPersistentDataContainerWrapper) {
            CustomNbtPersistentDataContainerWrapper wrapper = (CustomNbtPersistentDataContainerWrapper)container;
            PersistentDataContainer internalContainer = wrapper.getContainer();
            JavaPlugin plugin = this.getPlugin();
            NamespacedKey pluginKey = new NamespacedKey((Plugin)plugin, plugin.getName().toLowerCase(Locale.US));
            dataContainer.set(pluginKey, PersistentDataType.TAG_CONTAINER, (Object)internalContainer);
        }
        item.setItemMeta(itemMeta);
        return item;
    }

    @NotNull
    private PersistentDataContainer createNBT(@NotNull ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        Validate.notNull(itemMeta, "item must not have null meta!");
        JavaPlugin plugin = this.getPlugin();
        String pluginName = plugin.getName().toLowerCase(Locale.US);
        NamespacedKey pluginKey = new NamespacedKey((Plugin)plugin, pluginName);
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        if (dataContainer.has(pluginKey, PersistentDataType.TAG_CONTAINER)) {
            PersistentDataContainer subContainer = (PersistentDataContainer)dataContainer.get(pluginKey, PersistentDataType.TAG_CONTAINER);
            return Validate.notNull(subContainer, "subContainer must not be null!");
        }
        PersistentDataAdapterContext context = dataContainer.getAdapterContext();
        PersistentDataContainer newContainer = context.newPersistentDataContainer();
        dataContainer.set(pluginKey, PersistentDataType.TAG_CONTAINER, (Object)newContainer);
        return newContainer;
    }

    @Override
    @Nullable
    public Component getDisplayName(@NotNull ItemStack item) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        if (nmsItem.c(DataComponents.g)) {
            IChatBaseComponent component = nmsItem.y();
            return this.convert(component);
        }
        return null;
    }

    @Override
    @NotNull
    public ItemStack setDisplayName(@NotNull ItemStack item, @Nullable Component displayName) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        if (displayName == null) {
            if (nmsItem.c(DataComponents.g)) {
                nmsItem.e(DataComponents.g);
            }
        } else {
            IChatBaseComponent nmsComponent = this.convert(displayName);
            nmsItem.b(DataComponents.g, (Object)nmsComponent);
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
    }

    @Override
    @Nullable
    public List<Component> getLore(@NotNull ItemStack item) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!nmsItem.c(DataComponents.j)) {
            return null;
        }
        ItemLore itemLore = (ItemLore)nmsItem.a(DataComponents.j);
        if (itemLore == null) {
            return null;
        }
        List nmsLines = itemLore.a();
        List<Component> adventureLines = nmsLines.stream().map(this::convert).toList();
        return new ArrayList<Component>(adventureLines);
    }

    @Override
    @NotNull
    public ItemStack setLore(@NotNull ItemStack item, @Nullable List<Component> lore) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        if (lore == null) {
            if (nmsItem.c(DataComponents.j)) {
                nmsItem.e(DataComponents.j);
            }
        } else {
            ArrayList<IChatBaseComponent> nmsLines = new ArrayList<IChatBaseComponent>(lore.stream().map(this::convert).toList());
            ItemLore itemLore = new ItemLore(nmsLines);
            nmsItem.b(DataComponents.j, (Object)itemLore);
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
    }

    @NotNull
    private Component convert(@NotNull IChatBaseComponent component) {
        IRegistryCustom registry = CraftRegistry.getMinecraftRegistry();
        String json = CraftChatMessage.ChatSerializer.toJson((IChatBaseComponent)component, (HolderLookup.a)registry);
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        return serializer.deserialize(json);
    }

    @NotNull
    private IChatBaseComponent convert(@NotNull Component component) {
        IRegistryCustom registry;
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        String json = (String)serializer.serialize(component);
        IChatMutableComponent nmsComponent = CraftChatMessage.ChatSerializer.fromJson((String)json, (HolderLookup.a)(registry = CraftRegistry.getMinecraftRegistry()));
        if (nmsComponent != null) {
            return nmsComponent;
        }
        return IChatBaseComponent.b((String)json);
    }

    private int getCurrentDataVersion() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer craftServer = (CraftServer)server;
            DedicatedPlayerList handle = craftServer.getHandle();
            DedicatedServer dedicatedServer = handle.b();
            SaveData worldData = dedicatedServer.bf();
            return worldData.w();
        }
        return -1;
    }

    private int getDataVersion(NBTTagCompound nbt) {
        int defaultValue = this.getCurrentDataVersion();
        if (nbt.b("DataVersion")) {
            return nbt.b("DataVersion", -1);
        }
        return defaultValue;
    }

    private NBTTagCompound fixData(NBTTagCompound nbt) {
        int currentVersion = this.getCurrentDataVersion();
        int nbtVersion = this.getDataVersion(nbt);
        if (nbtVersion > currentVersion) {
            String message = String.format(Locale.US, "Can't fix data of newer NBT version. %s > %s.", nbtVersion, currentVersion);
            throw new IllegalStateException(message);
        }
        if (currentVersion == nbtVersion) {
            return nbt;
        }
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer craftServer = (CraftServer)server;
            DedicatedPlayerList handle = craftServer.getHandle();
            DedicatedServer dedicatedServer = handle.b();
            DataFixer dataFixer = dedicatedServer.aE();
            return (NBTTagCompound)dataFixer.update(DataConverterTypes.v, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbt), nbtVersion, currentVersion).getValue();
        }
        throw new IllegalStateException("The server is somehow not a CraftServer?!");
    }
}

