/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.nbt.CustomNbtContainer;
import com.github.sirblobman.api.nbt.modern.CustomNbtPersistentDataContainerWrapper;
import com.github.sirblobman.api.nbt.modern.PersistentDataConverter;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.serializer.gson.GsonComponentSerializer;
import com.github.sirblobman.api.utility.Validate;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.v1_16_R3.ChatComponentText;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IChatMutableComponent;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.MojangsonParser;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTCompressedStreamTools;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.NBTTagList;
import net.minecraft.server.v1_16_R3.NBTTagString;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHandler_1_16_R3
extends ItemHandler {
    public ItemHandler_1_16_R3(JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getLocalizedName(@NotNull org.bukkit.inventory.ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null && itemMeta.hasDisplayName()) {
            return itemMeta.getDisplayName();
        }
        ItemStack nmsItem = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
        IChatBaseComponent component = nmsItem.getName();
        return component.getText();
    }

    @Override
    @NotNull
    public String getKeyString(@NotNull org.bukkit.inventory.ItemStack item) {
        Material material = item.getType();
        NamespacedKey registryKey = material.getKey();
        return registryKey.toString();
    }

    @Override
    @NotNull
    public String toNBT(@NotNull org.bukkit.inventory.ItemStack item) {
        NBTTagCompound tag = new NBTTagCompound();
        ItemStack nmsItem = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
        nmsItem.save(tag);
        return tag.toString();
    }

    @Override
    @NotNull
    public org.bukkit.inventory.ItemStack fromNBT(@NotNull String string) {
        try {
            NBTTagCompound tag = MojangsonParser.parse((String)string);
            ItemStack nmsItem = ItemStack.a((NBTTagCompound)tag);
            return CraftItemStack.asBukkitCopy((ItemStack)nmsItem);
        }
        catch (CommandSyntaxException ex) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Failed to parse an NBT string to an ItemStack:", ex);
            logger.warning("The item will be replaced with air.");
            return new org.bukkit.inventory.ItemStack(Material.AIR);
        }
    }

    @Override
    @NotNull
    public String toBase64String(@NotNull org.bukkit.inventory.ItemStack item) {
        String string;
        NBTTagCompound tag = new NBTTagCompound();
        ItemStack nmsItem = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
        nmsItem.save(tag);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)tag, (OutputStream)outputStream);
            byte[] byteArray = outputStream.toByteArray();
            Base64.Encoder encoder = Base64.getEncoder();
            string = encoder.encodeToString(byteArray);
        }
        catch (Throwable byteArray) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {
                    byteArray.addSuppressed(throwable);
                }
                throw byteArray;
            }
            catch (IOException ex) {
                Logger logger = this.getLogger();
                logger.log(Level.WARNING, "Failed to encode an item to a string:", ex);
                logger.warning("The item will not be saved properly.");
                return "";
            }
        }
        outputStream.close();
        return string;
    }

    @Override
    @NotNull
    public org.bukkit.inventory.ItemStack fromBase64String(@NotNull String string) {
        org.bukkit.inventory.ItemStack itemStack;
        if (string.isEmpty()) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Decoded an empty string to air.");
            return new org.bukkit.inventory.ItemStack(Material.AIR);
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byteArray = decoder.decode(string);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        try {
            NBTTagCompound tag = NBTCompressedStreamTools.a((InputStream)inputStream);
            ItemStack nmsItem = ItemStack.a((NBTTagCompound)tag);
            itemStack = CraftItemStack.asBukkitCopy((ItemStack)nmsItem);
        }
        catch (Throwable tag) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    tag.addSuppressed(throwable);
                }
                throw tag;
            }
            catch (IOException ex) {
                Logger logger = this.getLogger();
                logger.log(Level.WARNING, "Failed to encode an item from a string:", ex);
                logger.warning("The item will be loaded as air.");
                return new org.bukkit.inventory.ItemStack(Material.AIR);
            }
        }
        inputStream.close();
        return itemStack;
    }

    @Override
    @NotNull
    public CustomNbtContainer createNewCustomNbtContainer() {
        org.bukkit.inventory.ItemStack item = new org.bukkit.inventory.ItemStack(Material.BARRIER);
        return this.getCustomNbt(item);
    }

    @Override
    @NotNull
    public CustomNbtContainer getCustomNbt(@NotNull org.bukkit.inventory.ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return this.createNewCustomNbtContainer();
        }
        JavaPlugin plugin = this.getPlugin();
        PersistentDataContainer dataContainer = this.createNBT(item);
        return PersistentDataConverter.convertContainer((Plugin)plugin, dataContainer);
    }

    @Override
    @NotNull
    public org.bukkit.inventory.ItemStack setCustomNbt(@NotNull org.bukkit.inventory.ItemStack item, @NotNull CustomNbtContainer container) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return item;
        }
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        if (container instanceof CustomNbtPersistentDataContainerWrapper) {
            CustomNbtPersistentDataContainerWrapper wrapper = (CustomNbtPersistentDataContainerWrapper)container;
            PersistentDataContainer internalContainer = wrapper.getContainer();
            JavaPlugin plugin = this.getPlugin();
            NamespacedKey pluginKey = new NamespacedKey((Plugin)plugin, plugin.getName().toLowerCase(Locale.US));
            dataContainer.set(pluginKey, PersistentDataType.TAG_CONTAINER, (Object)internalContainer);
        }
        item.setItemMeta(itemMeta);
        return item;
    }

    @NotNull
    private PersistentDataContainer createNBT(@NotNull org.bukkit.inventory.ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        Validate.notNull(itemMeta, "item must not have null meta!");
        JavaPlugin plugin = this.getPlugin();
        String pluginName = plugin.getName().toLowerCase(Locale.US);
        NamespacedKey pluginKey = new NamespacedKey((Plugin)plugin, pluginName);
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        if (dataContainer.has(pluginKey, PersistentDataType.TAG_CONTAINER)) {
            PersistentDataContainer subContainer = (PersistentDataContainer)dataContainer.get(pluginKey, PersistentDataType.TAG_CONTAINER);
            return Validate.notNull(subContainer, "subContainer must not be null!");
        }
        PersistentDataAdapterContext context = dataContainer.getAdapterContext();
        PersistentDataContainer newContainer = context.newPersistentDataContainer();
        dataContainer.set(pluginKey, PersistentDataType.TAG_CONTAINER, (Object)newContainer);
        return newContainer;
    }

    @Override
    @Nullable
    public Component getDisplayName(@NotNull org.bukkit.inventory.ItemStack item) {
        ItemStack nmsItem = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
        if (nmsItem.hasName()) {
            IChatBaseComponent nmsComponent = nmsItem.getName();
            return this.convert(nmsComponent);
        }
        return null;
    }

    @Override
    @NotNull
    public org.bukkit.inventory.ItemStack setDisplayName(@NotNull org.bukkit.inventory.ItemStack item, @Nullable Component displayName) {
        ItemStack nmsItem = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
        if (displayName == null) {
            nmsItem.a((IChatBaseComponent)null);
        } else {
            IChatBaseComponent nmsComponent = this.convert(displayName);
            nmsItem.a(nmsComponent);
        }
        return CraftItemStack.asBukkitCopy((ItemStack)nmsItem);
    }

    @Override
    @Nullable
    public List<Component> getLore(@NotNull org.bukkit.inventory.ItemStack item) {
        ItemStack nmsItem = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
        if (!nmsItem.hasTag()) {
            return null;
        }
        NBTTagCompound tag = nmsItem.getOrCreateTag();
        if (!tag.hasKeyOfType("display", 10)) {
            return null;
        }
        NBTTagCompound display = tag.getCompound("display");
        if (!display.hasKeyOfType("Lore", 9)) {
            return null;
        }
        NBTTagList list = display.getList("Lore", 8);
        ArrayList<String> loreJson = new ArrayList<String>(list.size());
        for (int index = 0; index < list.size(); ++index) {
            String line = list.getString(index);
            loreJson.add(line);
        }
        ArrayList<Component> componentLore = new ArrayList<Component>();
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        for (String json : loreJson) {
            if (json == null) {
                componentLore.add(Component.empty());
                continue;
            }
            Object component = serializer.deserialize(json);
            componentLore.add((Component)component);
        }
        return componentLore;
    }

    @Override
    @NotNull
    public org.bukkit.inventory.ItemStack setLore(@NotNull org.bukkit.inventory.ItemStack item, @Nullable List<Component> lore) {
        ItemStack nmsItem = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
        NBTTagCompound tag = nmsItem.getOrCreateTag();
        NBTTagCompound display = tag.getCompound("display");
        if (lore == null) {
            display.remove("Lore");
        } else {
            GsonComponentSerializer serializer = GsonComponentSerializer.gson();
            NBTTagList jsonList = new NBTTagList();
            for (Component component : lore) {
                String json = (String)serializer.serialize(component);
                NBTTagString stringTag = NBTTagString.a((String)json);
                jsonList.add((Object)stringTag);
            }
            display.set("Lore", (NBTBase)jsonList);
        }
        tag.set("display", (NBTBase)display);
        nmsItem.setTag(tag);
        return CraftItemStack.asBukkitCopy((ItemStack)nmsItem);
    }

    @NotNull
    private Component convert(@NotNull IChatBaseComponent component) {
        String json = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)component);
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        return serializer.deserialize(json);
    }

    @NotNull
    private IChatBaseComponent convert(@NotNull Component component) {
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        String json = (String)serializer.serialize(component);
        IChatMutableComponent nmsComponent = IChatBaseComponent.ChatSerializer.a((String)json);
        if (nmsComponent != null) {
            return nmsComponent;
        }
        return new ChatComponentText(json);
    }
}

