/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.language.ComponentHelper;
import com.github.sirblobman.api.nbt.CustomNbtContainer;
import com.github.sirblobman.api.nbt.CustomNbtContainer_1_12_R1;
import com.github.sirblobman.api.nbt.CustomNbtTypeRegistry_1_12_R1;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.minecraft.server.v1_12_R1.Item;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import net.minecraft.server.v1_12_R1.MojangsonParseException;
import net.minecraft.server.v1_12_R1.MojangsonParser;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTCompressedStreamTools;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemHandler_1_12_R1
extends ItemHandler {
    private final CustomNbtTypeRegistry_1_12_R1 registry = new CustomNbtTypeRegistry_1_12_R1();

    public ItemHandler_1_12_R1(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getLocalizedName(@NotNull ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null && itemMeta.hasDisplayName()) {
            return itemMeta.getDisplayName();
        }
        net.minecraft.server.v1_12_R1.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        return nmsItem.getName();
    }

    @Override
    @NotNull
    public String getKeyString(@NotNull ItemStack item) {
        net.minecraft.server.v1_12_R1.ItemStack nmsStack = CraftItemStack.asNMSCopy((ItemStack)item);
        Item nmsItem = nmsStack.getItem();
        MinecraftKey nmsRegistryKey = (MinecraftKey)Item.REGISTRY.b((Object)nmsItem);
        if (nmsRegistryKey == null) {
            return "minecraft:air";
        }
        return nmsRegistryKey.toString();
    }

    @Override
    @NotNull
    public String toNBT(@NotNull ItemStack item) {
        NBTTagCompound tag = new NBTTagCompound();
        net.minecraft.server.v1_12_R1.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        nmsItem.save(tag);
        return tag.toString();
    }

    @Override
    @NotNull
    public ItemStack fromNBT(@NotNull String string) {
        try {
            NBTTagCompound tag = MojangsonParser.parse((String)string);
            net.minecraft.server.v1_12_R1.ItemStack nmsItem = new net.minecraft.server.v1_12_R1.ItemStack(tag);
            return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_12_R1.ItemStack)nmsItem);
        }
        catch (MojangsonParseException ex) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Failed to parse an NBT string to an ItemStack:", ex);
            logger.warning("The item will be replaced with air.");
            return new ItemStack(Material.AIR);
        }
    }

    @Override
    @NotNull
    public String toBase64String(@NotNull ItemStack item) {
        String string;
        NBTTagCompound tag = new NBTTagCompound();
        net.minecraft.server.v1_12_R1.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        nmsItem.save(tag);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)tag, (OutputStream)outputStream);
            byte[] byteArray = outputStream.toByteArray();
            Base64.Encoder encoder = Base64.getEncoder();
            string = encoder.encodeToString(byteArray);
        }
        catch (Throwable byteArray) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {
                    byteArray.addSuppressed(throwable);
                }
                throw byteArray;
            }
            catch (IOException ex) {
                Logger logger = this.getLogger();
                logger.log(Level.WARNING, "Failed to encode an item to a string:", ex);
                logger.warning("The item will not be saved properly.");
                return "";
            }
        }
        outputStream.close();
        return string;
    }

    @Override
    @NotNull
    public ItemStack fromBase64String(@NotNull String string) {
        ItemStack itemStack;
        if (string.isEmpty()) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "Decoded an empty string to air.");
            return new ItemStack(Material.AIR);
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byteArray = decoder.decode(string);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        try {
            NBTTagCompound tag = NBTCompressedStreamTools.a((InputStream)inputStream);
            net.minecraft.server.v1_12_R1.ItemStack nmsItem = new net.minecraft.server.v1_12_R1.ItemStack(tag);
            itemStack = CraftItemStack.asBukkitCopy((net.minecraft.server.v1_12_R1.ItemStack)nmsItem);
        }
        catch (Throwable tag) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    tag.addSuppressed(throwable);
                }
                throw tag;
            }
            catch (IOException ex) {
                Logger logger = this.getLogger();
                logger.log(Level.WARNING, "Failed to encode an item from a string:", ex);
                logger.warning("The item will be loaded as air.");
                return new ItemStack(Material.AIR);
            }
        }
        inputStream.close();
        return itemStack;
    }

    @Override
    @NotNull
    public CustomNbtContainer createNewCustomNbtContainer() {
        return new CustomNbtContainer_1_12_R1(this.registry);
    }

    @Override
    @NotNull
    public CustomNbtContainer getCustomNbt(@NotNull ItemStack item) {
        net.minecraft.server.v1_12_R1.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        NBTTagCompound tag = this.createNBT(nmsItem);
        JavaPlugin plugin = this.getPlugin();
        String pluginName = plugin.getName();
        NBTTagCompound compound = tag.getCompound(pluginName);
        return this.registry.extract(CustomNbtContainer.class, (NBTBase)compound);
    }

    @Override
    @NotNull
    public ItemStack setCustomNbt(@NotNull ItemStack item, @NotNull CustomNbtContainer container) {
        net.minecraft.server.v1_12_R1.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        NBTTagCompound tag = this.createNBT(nmsItem);
        JavaPlugin plugin = this.getPlugin();
        String pluginName = plugin.getName();
        NBTBase wrap = this.registry.wrap(CustomNbtContainer.class, container);
        tag.set(pluginName, wrap);
        nmsItem.setTag(tag);
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_12_R1.ItemStack)nmsItem);
    }

    @NotNull
    private NBTTagCompound createNBT(@NotNull net.minecraft.server.v1_12_R1.ItemStack nmsItem) {
        NBTTagCompound tag;
        if (nmsItem.hasTag() && (tag = nmsItem.getTag()) != null) {
            return tag;
        }
        return new NBTTagCompound();
    }

    @Override
    @Nullable
    public Component getDisplayName(@NotNull ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null || !itemMeta.hasDisplayName()) {
            return null;
        }
        String legacyName = itemMeta.getDisplayName();
        return ComponentHelper.toComponent(legacyName);
    }

    @Override
    @NotNull
    public ItemStack setDisplayName(@NotNull ItemStack item, @Nullable Component displayName) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return item;
        }
        if (displayName == null) {
            itemMeta.setDisplayName(null);
        } else {
            String legacyName = ComponentHelper.toLegacy(displayName);
            itemMeta.setDisplayName(legacyName);
        }
        item.setItemMeta(itemMeta);
        return item;
    }

    @Override
    @Nullable
    public List<Component> getLore(@NotNull ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null || !itemMeta.hasLore()) {
            return null;
        }
        List legacyLore = itemMeta.getLore();
        return legacyLore.stream().map(ComponentHelper::toComponent).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public ItemStack setLore(@NotNull ItemStack item, @Nullable List<Component> lore) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return item;
        }
        if (lore == null) {
            itemMeta.setLore(null);
        } else {
            List legacyLore = lore.stream().map(ComponentHelper::toLegacy).collect(Collectors.toList());
            itemMeta.setLore(legacyLore);
        }
        item.setItemMeta(itemMeta);
        return item;
    }
}

