/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.nms.HeadHandler;
import com.github.sirblobman.api.shaded.xseries.XMaterial;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeadHandler_1_21_R3
extends HeadHandler {
    public HeadHandler_1_21_R3(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public ItemStack getPlayerHead(@NotNull OfflinePlayer player) {
        ItemStack item = XMaterial.PLAYER_HEAD.parseItem();
        if (item == null) {
            return new ItemStack(Material.AIR);
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return item;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        skullMeta.setOwningPlayer(player);
        item.setItemMeta((ItemMeta)skullMeta);
        return item;
    }

    @Override
    @NotNull
    public ItemStack getBase64Head(@NotNull String base64) {
        byte[] base64Bytes = base64.getBytes(StandardCharsets.UTF_8);
        UUID idFromBytes = UUID.nameUUIDFromBytes(base64Bytes);
        return this.getBase64Head(base64, idFromBytes);
    }

    @Override
    @NotNull
    public ItemStack getBase64Head(@NotNull String base64, @Nullable UUID customId) {
        ItemStack item = XMaterial.PLAYER_HEAD.parseItem();
        if (item == null) {
            return new ItemStack(Material.AIR);
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return item;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        PlayerProfile playerProfile = this.createPlayerProfile(base64, customId);
        skullMeta.setOwnerProfile(playerProfile);
        item.setItemMeta((ItemMeta)skullMeta);
        return item;
    }

    private PlayerProfile createPlayerProfile(String base64, UUID uniqueId) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)uniqueId, (String)"custom");
        PlayerTextures textures = profile.getTextures();
        URL skinUrl = this.decodeSkinUrl(base64);
        textures.setSkin(skinUrl);
        profile.setTextures(textures);
        return profile;
    }

    @Nullable
    private URL decodeSkinUrl(String base64) {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decode = decoder.decode(base64);
        String decodedString = new String(decode, StandardCharsets.UTF_8);
        JsonElement jsonElement = JsonParser.parseString((String)decodedString);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonObject textures = jsonObject.get("textures").getAsJsonObject();
        JsonObject skin = textures.get("SKIN").getAsJsonObject();
        String url = skin.get("url").getAsString();
        try {
            return URI.create(url).toURL();
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }
}

