/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.nms.Handler;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeadHandler
extends Handler {
    public HeadHandler(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @NotNull
    protected final String encodeBase64(@NotNull String original) {
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] originalByteArray = original.getBytes(StandardCharsets.UTF_8);
        byte[] base64ByteArray = encoder.encode(originalByteArray);
        return new String(base64ByteArray);
    }

    @NotNull
    protected final String encodeTextureURL(@NotNull String url) {
        JsonObject skin = new JsonObject();
        skin.addProperty("url", url);
        JsonObject textures = new JsonObject();
        textures.add("SKIN", (JsonElement)skin);
        JsonObject parent = new JsonObject();
        parent.add("textures", (JsonElement)textures);
        String jsonString = parent.toString();
        return this.encodeBase64(jsonString);
    }

    @NotNull
    public final ItemStack getTextureHead(@NotNull String url) {
        String base64 = this.encodeTextureURL(url);
        return this.getBase64Head(base64);
    }

    @NotNull
    public final ItemStack getTextureHead(@NotNull String url, @Nullable UUID customId) {
        String base64 = this.encodeTextureURL(url);
        return this.getBase64Head(base64, customId);
    }

    @Deprecated
    @NotNull
    public ItemStack getPlayerHead(@NotNull String username) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)username);
        return this.getPlayerHead(offlinePlayer);
    }

    @NotNull
    public abstract ItemStack getPlayerHead(@NotNull OfflinePlayer var1);

    @NotNull
    public abstract ItemStack getBase64Head(@NotNull String var1);

    @NotNull
    public abstract ItemStack getBase64Head(@NotNull String var1, @Nullable UUID var2);
}

