/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.nms.EntityHandler;
import com.github.sirblobman.api.shaded.xseries.XAttribute;
import com.github.sirblobman.api.utility.Validate;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class EntityHandler_Paper
extends EntityHandler {
    public EntityHandler_Paper(@NotNull JavaPlugin plugin) {
        super(plugin);
        Logger logger = this.getLogger();
        logger.info("Using non-NMS Paper EntityHandler");
    }

    @Override
    @NotNull
    public String getName(@NotNull Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getName();
        }
        String customName = entity.getCustomName();
        return customName != null ? customName : entity.getName();
    }

    @Override
    public void setCustomNameTextOnly(@NotNull Entity entity, String text, boolean visible) {
        TextComponent paperName = Component.text((String)text);
        entity.customName((Component)paperName);
    }

    @Override
    public double getMaxHealth(@NotNull LivingEntity entity) {
        Attribute attribute = (Attribute)XAttribute.MAX_HEALTH.get();
        if (attribute == null) {
            return entity.getHealth();
        }
        AttributeInstance instance = entity.getAttribute(attribute);
        if (instance == null) {
            return entity.getHealth();
        }
        return instance.getValue();
    }

    @Override
    public void setMaxHealth(@NotNull LivingEntity entity, double maxHealth) {
        AttributeInstance instance;
        Attribute attribute = (Attribute)XAttribute.MAX_HEALTH.get();
        if (attribute != null && (instance = entity.getAttribute(attribute)) != null) {
            instance.setBaseValue(maxHealth);
        }
    }

    @Override
    @NotNull
    public <T extends Entity> T spawnEntity(@NotNull Location location, @NotNull Class<T> entityClass, @NotNull Consumer<T> beforeSpawn) {
        World world = location.getWorld();
        Validate.notNull(world, "location must have a valid world.");
        try {
            Class<World> class_World = World.class;
            Method method_spawn = class_World.getMethod("spawn", Location.class, Class.class, Consumer.class);
            return (T)((Entity)method_spawn.invoke((Object)world, location, entityClass, beforeSpawn));
        }
        catch (ReflectiveOperationException ex) {
            return (T)world.spawn(location, entityClass, beforeSpawn::accept);
        }
    }
}

