/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.nms.EntityHandler;
import com.github.sirblobman.api.utility.VersionUtility;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class EntityHandler_Fallback
extends EntityHandler {
    public EntityHandler_Fallback(@NotNull JavaPlugin plugin) {
        super(plugin);
        String minecraftVersion = VersionUtility.getMinecraftVersion();
        String nmsVersion = VersionUtility.getNetMinecraftServerVersion();
        Logger logger = this.getLogger();
        logger.warning("Using fallback EntityHandler.");
        logger.warning("Version '" + minecraftVersion + "' and NMS '" + nmsVersion + "' combo is not supported.");
        logger.warning("Please contact SirBlobman if you believe this is a mistake.");
        logger.warning("https://github.com/SirBlobman/BlueSlimeCore/issues/new/choose");
    }

    @Override
    @NotNull
    public String getName(@NotNull Entity entity) {
        return entity.getName();
    }

    @Override
    public void setCustomNameTextOnly(@NotNull Entity entity, String text, boolean visible) {
        entity.setCustomName(text);
        entity.setCustomNameVisible(false);
    }

    @Override
    public double getMaxHealth(@NotNull LivingEntity entity) {
        return entity.getMaxHealth();
    }

    @Override
    public void setMaxHealth(@NotNull LivingEntity entity, double maxHealth) {
        entity.setMaxHealth(maxHealth);
    }

    @Override
    @NotNull
    public <T extends Entity> T spawnEntity(@NotNull Location location, @NotNull Class<T> entityClass, @NotNull Consumer<T> beforeSpawn) {
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("location must not have a null world.");
        }
        Entity entity = world.spawn(location, entityClass);
        beforeSpawn.accept(entity);
        return (T)entity;
    }
}

