/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nms;

import com.github.sirblobman.api.nms.EntityHandler;
import com.github.sirblobman.api.utility.Validate;
import java.util.function.Consumer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class EntityHandler_1_21_R5
extends EntityHandler {
    public EntityHandler_1_21_R5(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getName(@NotNull Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getName();
        }
        String customName = entity.getCustomName();
        return customName != null ? customName : entity.getName();
    }

    @Override
    public void setCustomNameTextOnly(@NotNull Entity entity, String text, boolean visible) {
        if (!(entity instanceof CraftEntity)) {
            return;
        }
        CraftEntity craftEntity = (CraftEntity)entity;
        net.minecraft.world.entity.Entity nmsEntity = craftEntity.getHandle();
        IChatMutableComponent component = IChatBaseComponent.b((String)text);
        nmsEntity.b((IChatBaseComponent)component);
        nmsEntity.p(visible);
    }

    @Override
    public double getMaxHealth(@NotNull LivingEntity entity) {
        AttributeInstance attribute = entity.getAttribute(Attribute.MAX_HEALTH);
        if (attribute != null) {
            return attribute.getValue();
        }
        return 0.0;
    }

    @Override
    public void setMaxHealth(@NotNull LivingEntity entity, double maxHealth) {
        AttributeInstance attribute = entity.getAttribute(Attribute.MAX_HEALTH);
        if (attribute != null) {
            attribute.setBaseValue(maxHealth);
        }
    }

    @Override
    @NotNull
    public <T extends Entity> T spawnEntity(@NotNull Location location, @NotNull Class<T> entityClass, @NotNull Consumer<T> beforeSpawn) {
        World world = location.getWorld();
        Validate.notNull(world, "location must have a valid world!");
        return (T)world.spawn(location, entityClass, beforeSpawn);
    }
}

