/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nbt.modern;

import com.github.sirblobman.api.nbt.CustomNbtContext;
import com.github.sirblobman.api.nbt.CustomNbtType;
import com.github.sirblobman.api.nbt.modern.PersistentDataConverter;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class CustomNbtPersistentDataTypeWrapper<T, Z>
implements PersistentDataType<T, Z> {
    private final Plugin plugin;
    private final CustomNbtType<T, Z> customNbtType;

    public CustomNbtPersistentDataTypeWrapper(@NotNull Plugin plugin, @NotNull CustomNbtType<T, Z> customNbtType) {
        this.plugin = plugin;
        this.customNbtType = customNbtType;
    }

    @NotNull
    public Class<T> getPrimitiveType() {
        CustomNbtType<T, Z> customNbtType = this.getCustomNbtType();
        return customNbtType.getPrimitiveType();
    }

    @NotNull
    public Class<Z> getComplexType() {
        CustomNbtType<T, Z> customNbtType = this.getCustomNbtType();
        return customNbtType.getComplexType();
    }

    @NotNull
    public T toPrimitive(@NotNull Z complex, @NotNull PersistentDataAdapterContext context) {
        Plugin plugin = this.getPlugin();
        CustomNbtType<T, Z> customNbtType = this.getCustomNbtType();
        CustomNbtContext convertedContext = PersistentDataConverter.convertContext(plugin, context);
        return customNbtType.toPrimitive(complex, convertedContext);
    }

    @NotNull
    public Z fromPrimitive(@NotNull T primitive, @NotNull PersistentDataAdapterContext context) {
        Plugin plugin = this.getPlugin();
        CustomNbtType<T, Z> customNbtType = this.getCustomNbtType();
        CustomNbtContext convertedContext = PersistentDataConverter.convertContext(plugin, context);
        return customNbtType.fromPrimitive(primitive, convertedContext);
    }

    @NotNull
    private Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    private CustomNbtType<T, Z> getCustomNbtType() {
        return this.customNbtType;
    }
}

