/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nbt.modern;

import com.github.sirblobman.api.nbt.CustomNbtContainer;
import com.github.sirblobman.api.nbt.CustomNbtContext;
import com.github.sirblobman.api.nbt.CustomNbtType;
import com.github.sirblobman.api.nbt.modern.PersistentDataConverter;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomNbtPersistentDataContainerWrapper
implements CustomNbtContainer {
    private final Plugin plugin;
    private final PersistentDataContainer container;

    public CustomNbtPersistentDataContainerWrapper(@NotNull Plugin plugin, @NotNull PersistentDataContainer container) {
        this.plugin = plugin;
        this.container = container;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public <T, Z> void set(@NotNull String key, @NotNull CustomNbtType<T, Z> type, @NotNull Z value) {
        Plugin plugin = this.getPlugin();
        NamespacedKey realKey = this.getKey(key);
        PersistentDataContainer container = this.getContainer();
        PersistentDataType<T, Z> realType = PersistentDataConverter.convertType(plugin, type);
        container.set(realKey, realType, value);
    }

    @Override
    public <T, Z> boolean has(@NotNull String key, @NotNull CustomNbtType<T, Z> type) {
        Plugin plugin = this.getPlugin();
        NamespacedKey realKey = this.getKey(key);
        PersistentDataContainer container = this.getContainer();
        PersistentDataType<T, Z> realType = PersistentDataConverter.convertType(plugin, type);
        return container.has(realKey, realType);
    }

    @Override
    @Nullable
    public <T, Z> Z get(@NotNull String key, @NotNull CustomNbtType<T, Z> type) {
        Plugin plugin = this.getPlugin();
        NamespacedKey realKey = this.getKey(key);
        PersistentDataContainer container = this.getContainer();
        PersistentDataType<T, Z> realType = PersistentDataConverter.convertType(plugin, type);
        return (Z)container.get(realKey, realType);
    }

    @Override
    @Nullable
    public <T, Z> Z getOrDefault(@NotNull String key, @NotNull CustomNbtType<T, Z> type, @Nullable Z defaultValue) {
        Plugin plugin = this.getPlugin();
        NamespacedKey realKey = this.getKey(key);
        PersistentDataContainer container = this.getContainer();
        PersistentDataType<T, Z> realType = PersistentDataConverter.convertType(plugin, type);
        if (defaultValue == null) {
            return (Z)container.get(realKey, realType);
        }
        return (Z)container.getOrDefault(realKey, realType, defaultValue);
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        try {
            PersistentDataContainer container = this.getContainer();
            Class containerClass = container.getClass();
            Method method_getKeys = containerClass.getMethod("getKeys", new Class[0]);
            Set realKeys = (Set)method_getKeys.invoke((Object)container, new Object[0]);
            return realKeys.parallelStream().map(NamespacedKey::getKey).collect(Collectors.toSet());
        }
        catch (ClassCastException | ReflectiveOperationException ignored) {
            return Collections.emptySet();
        }
    }

    @Override
    public void remove(@NotNull String key) {
        PersistentDataContainer container = this.getContainer();
        NamespacedKey realKey = this.getKey(key);
        container.remove(realKey);
    }

    @Override
    public boolean isEmpty() {
        PersistentDataContainer container = this.getContainer();
        return container.isEmpty();
    }

    @Override
    @NotNull
    public CustomNbtContext getContext() {
        Plugin plugin = this.getPlugin();
        PersistentDataContainer container = this.getContainer();
        return PersistentDataConverter.convertContext(plugin, container.getAdapterContext());
    }

    @NotNull
    public PersistentDataContainer getContainer() {
        return this.container;
    }

    @NotNull
    private NamespacedKey getKey(String key) {
        Plugin plugin = this.getPlugin();
        return new NamespacedKey(plugin, key);
    }
}

