/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nbt.custom;

import com.github.sirblobman.api.nbt.CustomNbtContext;
import com.github.sirblobman.api.nbt.CustomNbtType;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CustomNbtTypeUUID
implements CustomNbtType<byte[], UUID> {
    @Override
    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @Override
    @NotNull
    public Class<UUID> getComplexType() {
        return UUID.class;
    }

    @Override
    public byte @NotNull [] toPrimitive(@NotNull UUID complex, @NotNull CustomNbtContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(complex.getMostSignificantBits());
        byteBuffer.putLong(complex.getLeastSignificantBits());
        return byteBuffer.array();
    }

    @Override
    @NotNull
    public UUID fromPrimitive(byte @NotNull [] primitive, @NotNull CustomNbtContext context) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(primitive);
        long mostSignificantBits = byteBuffer.getLong();
        long leastSignificantBits = byteBuffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }
}

