/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nbt;

import com.github.sirblobman.api.nbt.Adapter_1_12_R1;
import com.github.sirblobman.api.nbt.CustomNbtContainer;
import com.github.sirblobman.api.nbt.CustomNbtContainer_1_12_R1;
import com.google.common.primitives.Primitives;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagByte;
import net.minecraft.server.v1_12_R1.NBTTagByteArray;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.NBTTagDouble;
import net.minecraft.server.v1_12_R1.NBTTagFloat;
import net.minecraft.server.v1_12_R1.NBTTagInt;
import net.minecraft.server.v1_12_R1.NBTTagIntArray;
import net.minecraft.server.v1_12_R1.NBTTagLong;
import net.minecraft.server.v1_12_R1.NBTTagShort;
import net.minecraft.server.v1_12_R1.NBTTagString;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public final class CustomNbtTypeRegistry_1_12_R1 {
    private final Function<Class<?>, Adapter_1_12_R1<?, ?>> CREATE_ADAPTER = this::createAdapter;
    private final Map<Class<?>, Adapter_1_12_R1<?, ?>> adapters = new HashMap();

    private <T> Adapter_1_12_R1<?, ?> createAdapter(@NotNull Class<T> type) {
        if (!Primitives.isWrapperType(type)) {
            type = Primitives.wrap(type);
        }
        if (Objects.equals(Byte.class, type)) {
            return this.createAdapter(Byte.class, NBTTagByte.class, NBTTagByte::new, NBTTagByte::g);
        }
        if (Objects.equals(Short.class, type)) {
            return this.createAdapter(Short.class, NBTTagShort.class, NBTTagShort::new, NBTTagShort::f);
        }
        if (Objects.equals(Integer.class, type)) {
            return this.createAdapter(Integer.class, NBTTagInt.class, NBTTagInt::new, NBTTagInt::e);
        }
        if (Objects.equals(Long.class, type)) {
            return this.createAdapter(Long.class, NBTTagLong.class, NBTTagLong::new, NBTTagLong::d);
        }
        if (Objects.equals(Float.class, type)) {
            return this.createAdapter(Float.class, NBTTagFloat.class, NBTTagFloat::new, NBTTagFloat::i);
        }
        if (Objects.equals(Double.class, type)) {
            return this.createAdapter(Double.class, NBTTagDouble.class, NBTTagDouble::new, NBTTagDouble::asDouble);
        }
        if (Objects.equals(String.class, type)) {
            return this.createAdapter(String.class, NBTTagString.class, NBTTagString::new, NBTTagString::c_);
        }
        if (Objects.equals(byte[].class, type)) {
            return this.createAdapter(byte[].class, NBTTagByteArray.class, array -> new NBTTagByteArray(Arrays.copyOf(array, ((byte[])array).length)), n -> Arrays.copyOf(n.c(), n.c().length));
        }
        if (Objects.equals(int[].class, type)) {
            return this.createAdapter(int[].class, NBTTagIntArray.class, array -> new NBTTagIntArray(Arrays.copyOf(array, ((int[])array).length)), n -> Arrays.copyOf(n.d(), n.d().length));
        }
        if (Objects.equals(long[].class, type)) {
            return this.createAdapter(long[].class, NBTTagString.class, this::longArrayToNBT, this::nbtToLongArray);
        }
        if (Objects.equals(CustomNbtContainer.class, type)) {
            return this.createAdapter(CustomNbtContainer_1_12_R1.class, NBTTagCompound.class, CustomNbtContainer_1_12_R1::toTagCompound, this::tagToContainer);
        }
        throw new IllegalArgumentException("Could not find a valid CustomNbtTagAdapter implementation for the requested type " + type.getSimpleName());
    }

    @NotNull
    private CustomNbtContainer_1_12_R1 tagToContainer(@NotNull NBTTagCompound tag) {
        CustomNbtContainer_1_12_R1 container = new CustomNbtContainer_1_12_R1(this);
        Set keySet = tag.c();
        for (String key : keySet) {
            NBTBase value = tag.get(key);
            container.put(key, value);
        }
        return container;
    }

    @NotNull
    private NBTTagString longArrayToNBT(long @NotNull [] longArray) {
        StringBuilder builder = new StringBuilder();
        for (long part : longArray) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(part);
        }
        String value = builder.toString();
        return new NBTTagString(value);
    }

    private long @NotNull [] nbtToLongArray(@NotNull NBTTagString nbt) {
        String string = nbt.c_();
        String[] split = string.split(Pattern.quote(";"));
        int splitLength = split.length;
        try {
            long[] longArray = new long[splitLength];
            for (int i = 0; i < split.length; ++i) {
                String part = split[i];
                longArray[i] = Long.parseLong(part);
            }
            return longArray;
        }
        catch (NumberFormatException ex) {
            return new long[0];
        }
    }

    @NotNull
    private <T, Z extends NBTBase> Adapter_1_12_R1<T, Z> createAdapter(@NotNull Class<T> primitiveType, @NotNull Class<Z> nbtBaseType, @NotNull Function<T, Z> builder, @NotNull Function<Z, T> extractor) {
        return new Adapter_1_12_R1<T, Z>(primitiveType, nbtBaseType, builder, extractor);
    }

    @NotNull
    public <T> NBTBase wrap(@NotNull Class<T> type, @NotNull T value) {
        return this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER).build(value);
    }

    public <T> boolean isInstanceOf(@NotNull Class<T> type, @NotNull NBTBase base) {
        return this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER).isInstance(base);
    }

    @NotNull
    public <T> T extract(@NotNull Class<T> type, @NotNull NBTBase tag) throws ClassCastException, IllegalArgumentException {
        Adapter_1_12_R1<?, ?> adapter = this.adapters.computeIfAbsent(type, this.CREATE_ADAPTER);
        Validate.isTrue((boolean)adapter.isInstance(tag), (String)"`The found tag instance cannot store %s as it is a %s", (Object[])new Object[]{type.getSimpleName(), tag.getClass().getSimpleName()});
        Object foundValue = adapter.extract(tag);
        Validate.isInstanceOf(type, foundValue, (String)"The found object is of the type %s. Expected type %s", (Object[])new Object[]{foundValue.getClass().getSimpleName(), type.getSimpleName()});
        return type.cast(foundValue);
    }
}

