/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.nbt;

import com.github.sirblobman.api.nbt.CustomNbtContainer;
import com.github.sirblobman.api.nbt.CustomNbtContext;
import com.github.sirblobman.api.nbt.CustomNbtContext_1_12_R1;
import com.github.sirblobman.api.nbt.CustomNbtType;
import com.github.sirblobman.api.nbt.CustomNbtTypeRegistry_1_12_R1;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.server.v1_12_R1.NBTBase;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomNbtContainer_1_12_R1
implements CustomNbtContainer {
    private final Map<String, NBTBase> customDataTags = new HashMap<String, NBTBase>();
    private final CustomNbtTypeRegistry_1_12_R1 registry;
    private final CustomNbtContext_1_12_R1 adapterContext;

    public CustomNbtContainer_1_12_R1(@NotNull Map<String, NBTBase> customTags, @NotNull CustomNbtTypeRegistry_1_12_R1 registry) {
        this(registry);
        this.customDataTags.putAll(customTags);
    }

    public CustomNbtContainer_1_12_R1(@NotNull CustomNbtTypeRegistry_1_12_R1 registry) {
        this.registry = registry;
        this.adapterContext = new CustomNbtContext_1_12_R1(this.registry);
    }

    @Override
    public <T, Z> void set(@NotNull String key, @NotNull CustomNbtType<T, Z> type, @NotNull Z value) {
        Class<T> primitiveType = type.getPrimitiveType();
        T primitiveValue = type.toPrimitive(value, this.adapterContext);
        NBTBase wrap = this.registry.wrap(primitiveType, primitiveValue);
        this.customDataTags.put(key, wrap);
    }

    @Override
    public <T, Z> boolean has(@NotNull String key, @NotNull CustomNbtType<T, Z> type) {
        NBTBase value = this.customDataTags.get(key);
        if (value == null) {
            return false;
        }
        Class<T> primitiveType = type.getPrimitiveType();
        return this.registry.isInstanceOf(primitiveType, value);
    }

    @Override
    @Nullable
    public <T, Z> Z get(@NotNull String key, @NotNull CustomNbtType<T, Z> type) {
        NBTBase value = this.customDataTags.get(key);
        if (value == null) {
            return null;
        }
        Class<T> primitiveType = type.getPrimitiveType();
        T extract = this.registry.extract(primitiveType, value);
        return type.fromPrimitive(extract, this.adapterContext);
    }

    @Override
    @Nullable
    public <T, Z> Z getOrDefault(@NotNull String key, @NotNull CustomNbtType<T, Z> type, @Nullable Z defaultValue) {
        Z value = this.get(key, type);
        return value != null ? value : defaultValue;
    }

    @Override
    public void remove(@NotNull String key) {
        this.customDataTags.remove(key);
    }

    @Override
    public boolean isEmpty() {
        return this.customDataTags.isEmpty();
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        Set<String> keySet = this.customDataTags.keySet();
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    @NotNull
    public CustomNbtContext getContext() {
        return this.adapterContext;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CustomNbtContainer_1_12_R1)) {
            return false;
        }
        Map<String, NBTBase> myRawMap = this.getRaw();
        Map<String, NBTBase> theirRawMap = ((CustomNbtContainer_1_12_R1)obj).getRaw();
        return Objects.equals(myRawMap, theirRawMap);
    }

    @NotNull
    public NBTTagCompound toTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        Set<Map.Entry<String, NBTBase>> entrySet = this.customDataTags.entrySet();
        for (Map.Entry<String, NBTBase> entry : entrySet) {
            String key = entry.getKey();
            NBTBase value = entry.getValue();
            tag.set(key, value);
        }
        return tag;
    }

    public void put(@NotNull String key, @NotNull NBTBase base) {
        this.customDataTags.put(key, base);
    }

    @NotNull
    public Map<String, NBTBase> getRaw() {
        return this.customDataTags;
    }

    public int hashCode() {
        int hashCode = 3;
        return hashCode += this.customDataTags.hashCode();
    }
}

