/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.menu.button;

import com.github.sirblobman.api.folia.scheduler.TaskScheduler;
import com.github.sirblobman.api.menu.IMenu;
import com.github.sirblobman.api.menu.button.QuickButton;
import com.github.sirblobman.api.menu.task.MenuOpenTask;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class OpenParentMenuButton<P extends Plugin>
extends QuickButton {
    private final IMenu menu;

    public OpenParentMenuButton(@NotNull IMenu menu) {
        this.menu = menu;
    }

    @NotNull
    private IMenu getMenu() {
        return this.menu;
    }

    @NotNull
    private Optional<IMenu> getParentMenu() {
        IMenu menu = this.getMenu();
        return menu.getParentMenu();
    }

    @Override
    public void onLeftClick(@NotNull Player player, boolean shift) {
        Optional<IMenu> optionalParentMenu = this.getParentMenu();
        if (!optionalParentMenu.isPresent()) {
            return;
        }
        IMenu parentMenu = optionalParentMenu.get();
        Plugin plugin = parentMenu.getPlugin();
        MenuOpenTask task = new MenuOpenTask(plugin, player, parentMenu);
        TaskScheduler scheduler = parentMenu.getTaskScheduler();
        scheduler.scheduleEntityTask(task);
    }
}

