/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.menu;

import com.github.sirblobman.api.item.ItemBuilder;
import com.github.sirblobman.api.item.SkullBuilder;
import com.github.sirblobman.api.language.ComponentHelper;
import com.github.sirblobman.api.language.LanguageManager;
import com.github.sirblobman.api.menu.IMenu;
import com.github.sirblobman.api.nms.HeadHandler;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.nms.MultiVersionHandler;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.minimessage.MiniMessage;
import com.github.sirblobman.api.shaded.xseries.XMaterial;
import com.github.sirblobman.api.utility.MessageUtility;
import com.github.sirblobman.api.utility.paper.PaperChecker;
import com.github.sirblobman.api.utility.paper.PaperHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMenu<P extends Plugin>
implements IMenu {
    private IMenu parentMenu;

    public BaseMenu() {
        this(null);
    }

    public BaseMenu(@Nullable IMenu parentMenu) {
        this.parentMenu = parentMenu;
    }

    @Override
    @NotNull
    public Optional<IMenu> getParentMenu() {
        return Optional.ofNullable(this.parentMenu);
    }

    @Override
    public void setParentMenu(@NotNull IMenu parentMenu) {
        this.parentMenu = parentMenu;
    }

    @Nullable
    public HeadHandler getHeadHandler() {
        MultiVersionHandler multiVersionHandler = this.getMultiVersionHandler();
        if (multiVersionHandler == null) {
            return null;
        }
        return multiVersionHandler.getHeadHandler();
    }

    @Nullable
    public ItemHandler getItemHandler() {
        MultiVersionHandler multiVersionHandler = this.getMultiVersionHandler();
        if (multiVersionHandler == null) {
            return null;
        }
        return multiVersionHandler.getItemHandler();
    }

    @NotNull
    public Inventory getInventory(int size) {
        if (size == 5) {
            return Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.HOPPER);
        }
        if (size < 9) {
            throw new IllegalArgumentException("size must be equal to 5 or at least 9");
        }
        if (size > 54) {
            throw new IllegalArgumentException("size cannot be more than 54");
        }
        if (size % 9 != 0) {
            throw new IllegalArgumentException("size must be equal to 5 or divisible by 9");
        }
        return Bukkit.createInventory((InventoryHolder)this, (int)size);
    }

    @NotNull
    public Inventory getInventory(int size, @Nullable String title) {
        if (title == null) {
            return this.getInventory(size);
        }
        String colorTitle = MessageUtility.color(title);
        if (size == 5) {
            return Bukkit.createInventory((InventoryHolder)this, (InventoryType)InventoryType.HOPPER, (String)colorTitle);
        }
        if (size < 9) {
            throw new IllegalArgumentException("size must be equal to 5 or at least 9");
        }
        if (size > 54) {
            throw new IllegalArgumentException("size cannot be more than 54");
        }
        if (size % 9 != 0) {
            throw new IllegalArgumentException("size must be equal to 5 or divisible by 9");
        }
        return Bukkit.createInventory((InventoryHolder)this, (int)size, (String)colorTitle);
    }

    @NotNull
    public Inventory getInventory(int size, @Nullable Component title) {
        if (title == null) {
            return this.getInventory(size);
        }
        if (PaperChecker.hasNativeComponentSupport()) {
            return PaperHelper.createInventory(this, size, title);
        }
        String legacyTitle = ComponentHelper.toLegacy(title);
        return this.getInventory(size, legacyTitle);
    }

    @Nullable
    protected final ItemStack loadItemStack(@NotNull ConfigurationSection config, @NotNull String path) {
        if (config.isItemStack(path)) {
            return config.getItemStack(path);
        }
        ConfigurationSection section = config.getConfigurationSection(path);
        if (section == null) {
            return null;
        }
        return this.loadItemStack(section);
    }

    @Nullable
    private ItemStack loadItemStack(@NotNull ConfigurationSection section) {
        String materialName = section.getString("material");
        Optional<XMaterial> optionalMaterial = XMaterial.matchXMaterial(materialName);
        if (!optionalMaterial.isPresent()) {
            Logger logger = this.getLogger();
            logger.warning("Unknown material name '" + materialName + "'.");
            return null;
        }
        XMaterial material = optionalMaterial.get();
        ItemBuilder builder = new ItemBuilder(material);
        builder = this.checkSkull(builder, material, section);
        builder = this.checkNameAndLore(builder, section);
        int amount = section.getInt("quantity", 1);
        builder = builder.withAmount(amount);
        int damage = section.getInt("damage", 0);
        builder = builder.withDamage(damage);
        Integer model = section.isSet("model") ? Integer.valueOf(section.getInt("model")) : null;
        builder = builder.withModel(model);
        if (section.getBoolean("glowing")) {
            builder = builder.withGlowing();
        }
        return builder.build();
    }

    @NotNull
    private ItemBuilder checkNameAndLore(@NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        builder = this.checkDisplayName(builder, section);
        builder = this.checkLore(builder, section);
        return builder;
    }

    @NotNull
    private ItemBuilder checkDisplayName(@NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        String displayNameString = section.getString("display-name");
        if (displayNameString == null) {
            return builder;
        }
        LanguageManager languageManager = this.getLanguageManager();
        ItemHandler itemHandler = this.getItemHandler();
        if (languageManager == null || itemHandler == null) {
            String displayNameFormatted = MessageUtility.color(displayNameString);
            return builder.withName(displayNameFormatted);
        }
        MiniMessage miniMessage = languageManager.getMiniMessage();
        Object displayName = miniMessage.deserialize(displayNameString);
        return builder.withName(itemHandler, ComponentHelper.wrapNoItalics(displayName));
    }

    @NotNull
    private ItemBuilder checkLore(@NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        List loreString = section.getStringList("lore");
        if (loreString.isEmpty()) {
            return builder;
        }
        LanguageManager languageManager = this.getLanguageManager();
        ItemHandler itemHandler = this.getItemHandler();
        if (languageManager == null || itemHandler == null) {
            List<String> loreFormatted = MessageUtility.colorList(loreString);
            return builder.withLore(loreFormatted);
        }
        ArrayList<Component> lore = new ArrayList<Component>();
        MiniMessage miniMessage = languageManager.getMiniMessage();
        for (String lineString : loreString) {
            Object line = miniMessage.deserialize(lineString);
            lore.add((Component)line);
        }
        return builder.withLore(itemHandler, ComponentHelper.wrapNoItalics(lore));
    }

    @NotNull
    private ItemBuilder checkSkull(@NotNull ItemBuilder builder, @NotNull XMaterial material, @NotNull ConfigurationSection section) {
        HeadHandler headHandler = this.getHeadHandler();
        if (material != XMaterial.PLAYER_HEAD || headHandler == null) {
            return builder;
        }
        String texture = section.getString("texture");
        if (texture != null) {
            SkullBuilder skullBuilder = new SkullBuilder(headHandler);
            return skullBuilder.withTextureBase64(texture);
        }
        String textureUrl = section.getString("texture-url");
        if (textureUrl != null) {
            SkullBuilder skullBuilder = new SkullBuilder(headHandler);
            return skullBuilder.withTextureUrl(textureUrl);
        }
        String username = section.getString("skull-owner");
        if (username != null) {
            SkullBuilder skullBuilder = new SkullBuilder(headHandler);
            return skullBuilder.withOwner(username);
        }
        return builder;
    }
}

