/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.menu;

import com.github.sirblobman.api.folia.FoliaHelper;
import com.github.sirblobman.api.folia.FoliaPlugin;
import com.github.sirblobman.api.folia.scheduler.BukkitTaskScheduler;
import com.github.sirblobman.api.folia.scheduler.TaskScheduler;
import com.github.sirblobman.api.folia.task.WrappedTask;
import com.github.sirblobman.api.menu.BaseMenu;
import com.github.sirblobman.api.menu.IMenu;
import com.github.sirblobman.api.menu.task.AdvancedMenuInternalOpenTask;
import com.github.sirblobman.api.menu.task.AdvancedMenuRefreshLoopTask;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdvancedAbstractMenu<P extends Plugin>
extends BaseMenu<P>
implements Runnable {
    private final P plugin;
    private final TaskScheduler scheduler;
    private final Player player;
    private WrappedTask currentTask;
    private final List<Listener> listenerList;

    public AdvancedAbstractMenu(@NotNull P plugin, @NotNull Player player) {
        this(null, plugin, player);
    }

    public AdvancedAbstractMenu(@Nullable IMenu parentMenu, @NotNull P plugin, @NotNull Player player) {
        super(parentMenu);
        this.plugin = plugin;
        if (plugin instanceof FoliaPlugin) {
            FoliaHelper foliaHelper = ((FoliaPlugin)plugin).getFoliaHelper();
            this.scheduler = foliaHelper.getScheduler();
        } else {
            this.scheduler = new BukkitTaskScheduler((Plugin)plugin);
        }
        this.player = player;
        this.currentTask = null;
        this.listenerList = new ArrayList<Listener>();
    }

    @NotNull
    public P getPlugin() {
        return this.plugin;
    }

    @Override
    public void registerListeners() {
        super.registerListeners();
        PluginManager pluginManager = Bukkit.getPluginManager();
        Listener listener = this.getInventoryListener();
        this.listenerList.add(listener);
        pluginManager.registerEvents(listener, this.getPlugin());
    }

    @NotNull
    private Listener getInventoryListener() {
        try {
            String packageName = AdvancedAbstractMenu.class.getPackageName();
            Class<?> class_InventoryView = Class.forName("org.bukkit.inventory.InventoryView");
            if (class_InventoryView.isInterface()) {
                Class<?> newListener = Class.forName(packageName + ".listener.NewInventoryListener");
                Constructor<?> constructor = newListener.getConstructor(AdvancedAbstractMenu.class);
                return (Listener)constructor.newInstance(this);
            }
            Class<?> newListener = Class.forName(packageName + ".listener.InventoryListener");
            Constructor<?> constructor = newListener.getConstructor(AdvancedAbstractMenu.class);
            return (Listener)constructor.newInstance(this);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("InventoryView class does not exist in the expected path.", ex);
        }
    }

    @Override
    @NotNull
    public TaskScheduler getTaskScheduler() {
        return this.scheduler;
    }

    @Override
    public void run() {
    }

    @Override
    public void onCustomClose(@NotNull InventoryCloseEvent e) {
        this.onValidClose(e);
    }

    public void onCustomClick(@NotNull InventoryClickEvent e) {
        this.onValidClick(e);
    }

    public void onCustomDrag(@NotNull InventoryDragEvent e) {
        this.onValidDrag(e);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @Override
    public void open() {
        P plugin = this.getPlugin();
        Player player = this.getPlayer();
        player.closeInventory();
        TaskScheduler scheduler = this.getTaskScheduler();
        AdvancedMenuInternalOpenTask task = new AdvancedMenuInternalOpenTask((Plugin)plugin, player, this);
        scheduler.scheduleEntityTask(task);
        AdvancedMenuRefreshLoopTask timer = new AdvancedMenuRefreshLoopTask((Plugin)plugin, player, this);
        this.currentTask = scheduler.scheduleEntityTask(timer);
    }

    public void internalClose() {
        for (Listener listener : this.listenerList) {
            HandlerList.unregisterAll((Listener)listener);
        }
        if (this.currentTask == null) {
            return;
        }
        try {
            this.currentTask.cancel();
        }
        catch (Exception exception) {
        }
        finally {
            this.currentTask = null;
        }
    }

    @NotNull
    public abstract Inventory getInventory();

    protected abstract void onValidClose(@NotNull InventoryCloseEvent var1);

    protected abstract void onValidClick(@NotNull InventoryClickEvent var1);

    protected abstract void onValidDrag(@NotNull InventoryDragEvent var1);
}

