/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.menu;

import com.github.sirblobman.api.menu.AbstractMenu;
import com.github.sirblobman.api.menu.IMenu;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.TextReplacementConfig;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPagedMenu<P extends Plugin>
extends AbstractMenu<P> {
    private int currentPage = 1;

    public AbstractPagedMenu(@NotNull P plugin, @NotNull Player player) {
        this(null, plugin, player);
    }

    public AbstractPagedMenu(@Nullable IMenu parentMenu, @NotNull P plugin, @NotNull Player player) {
        super(parentMenu, plugin, player);
    }

    @Override
    public Component getTitle() {
        Component titleFormat = this.getTitleFormat();
        if (titleFormat == null) {
            return null;
        }
        TextReplacementConfig.Builder replacementBuilder = TextReplacementConfig.builder();
        replacementBuilder.matchLiteral("{page}").replacement(Component.text(this.currentPage));
        TextReplacementConfig replacementConfig = (TextReplacementConfig)replacementBuilder.build();
        return titleFormat.replaceText(replacementConfig);
    }

    public final int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int page) {
        this.currentPage = page;
    }

    public final void openNextPage() {
        int maximumPage;
        int newPage;
        int currentPage = this.getCurrentPage();
        if (currentPage == (newPage = Math.min(currentPage + 1, maximumPage = this.getMaxPages()))) {
            return;
        }
        this.setCurrentPage(newPage);
        this.open();
    }

    public final void openPreviousPage() {
        int newPage;
        int currentPage = this.getCurrentPage();
        if (currentPage == (newPage = Math.max(currentPage - 1, 1))) {
            return;
        }
        this.setCurrentPage(newPage);
        this.open();
    }

    public abstract int getMaxPages();

    public abstract Component getTitleFormat();
}

