/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.menu;

import com.github.sirblobman.api.folia.FoliaHelper;
import com.github.sirblobman.api.folia.FoliaPlugin;
import com.github.sirblobman.api.folia.scheduler.BukkitTaskScheduler;
import com.github.sirblobman.api.folia.scheduler.TaskScheduler;
import com.github.sirblobman.api.menu.BaseMenu;
import com.github.sirblobman.api.menu.IMenu;
import com.github.sirblobman.api.menu.button.IButton;
import com.github.sirblobman.api.menu.task.AbstractMenuInternalOpenTask;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMenu<P extends Plugin>
extends BaseMenu<P> {
    private final P plugin;
    private final Player player;
    private final TaskScheduler scheduler;
    private final Map<Integer, IButton> buttonMap;

    public AbstractMenu(@NotNull P plugin, @NotNull Player player) {
        this(null, plugin, player);
    }

    public AbstractMenu(@Nullable IMenu parentMenu, @NotNull P plugin, @NotNull Player player) {
        super(parentMenu);
        if (!player.isOnline()) {
            throw new IllegalArgumentException("player must be online!");
        }
        if (plugin instanceof FoliaPlugin) {
            FoliaHelper foliaHelper = ((FoliaPlugin)plugin).getFoliaHelper();
            this.scheduler = foliaHelper.getScheduler();
        } else {
            this.scheduler = new BukkitTaskScheduler((Plugin)plugin);
        }
        this.plugin = plugin;
        this.player = player;
        this.buttonMap = new ConcurrentHashMap<Integer, IButton>();
    }

    @NotNull
    public final P getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public TaskScheduler getTaskScheduler() {
        return this.scheduler;
    }

    @NotNull
    public Inventory getInventory() {
        int size = this.getSize();
        Component title = this.getTitle();
        Inventory inventory = this.getInventory(size, title);
        ItemStack[] contents = inventory.getContents();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack item;
            contents[slot] = item = this.getItem(slot);
            IButton button = this.getButton(slot);
            this.setButton(slot, button);
        }
        inventory.setContents(contents);
        return inventory;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public final void onClick(InventoryClickEvent e) {
        int rawSlot;
        IButton button;
        Inventory inventory = e.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (!this.equals(holder)) {
            return;
        }
        Inventory clickedInventory = e.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        ClickType clickType = e.getClick();
        InventoryType clickedInventoryType = clickedInventory.getType();
        if (clickedInventoryType == InventoryType.PLAYER && clickType.isShiftClick() && this.shouldCancelShiftClickFromPlayerInventory()) {
            e.setCancelled(true);
            return;
        }
        int slot = e.getSlot();
        if (this.shouldPreventClick(slot)) {
            e.setCancelled(true);
        }
        if ((button = this.internalGetButton(rawSlot = e.getRawSlot())) != null) {
            button.onClick(e);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onClose(InventoryCloseEvent e) {
        Inventory inventory = e.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (!this.equals(holder)) {
            return;
        }
        this.onCustomClose(e);
        HandlerList.unregisterAll((Listener)this);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @Override
    public void open() {
        P plugin = this.getPlugin();
        Player player = this.getPlayer();
        player.closeInventory();
        TaskScheduler scheduler = this.getTaskScheduler();
        AbstractMenuInternalOpenTask task = new AbstractMenuInternalOpenTask((Plugin)plugin, player, this);
        scheduler.scheduleEntityTask(task);
    }

    public boolean shouldCancelShiftClickFromPlayerInventory() {
        return true;
    }

    public void resetButtons() {
        this.buttonMap.clear();
    }

    protected final void setButton(int slot, @Nullable IButton button) {
        if (button == null) {
            this.buttonMap.remove(slot);
            return;
        }
        this.buttonMap.put(slot, button);
    }

    @Nullable
    private IButton internalGetButton(int slot) {
        return this.buttonMap.getOrDefault(slot, null);
    }

    public abstract int getSize();

    @Nullable
    public abstract ItemStack getItem(int var1);

    @Nullable
    public abstract IButton getButton(int var1);

    @Override
    @Nullable
    public abstract Component getTitle();

    public abstract boolean shouldPreventClick(int var1);

    @Override
    public void onCustomClose(@NotNull InventoryCloseEvent e) {
    }
}

