/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.location;

import com.github.sirblobman.api.utility.Validate;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityLocation {
    private final UUID worldId;
    private final double x;
    private final double y;
    private final double z;
    private final double yaw;
    private final double pitch;

    public EntityLocation(@NotNull UUID worldId, double x, double y, double z, double yaw, double pitch) {
        this.worldId = Validate.notNull(worldId, "worldId must not be null!");
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @NotNull
    public static EntityLocation from(@NotNull World world, double x, double y, double z, double yaw, double pitch) {
        UUID worldId = world.getUID();
        return new EntityLocation(worldId, x, y, z, yaw, pitch);
    }

    @NotNull
    public static EntityLocation from(@NotNull Location location) {
        World world = location.getWorld();
        Validate.notNull(world, "world must not be null!");
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        double yaw = location.getYaw();
        double pitch = location.getPitch();
        return EntityLocation.from(world, x, y, z, yaw, pitch);
    }

    @NotNull
    public static EntityLocation from(@NotNull Entity entity) {
        Location location = entity.getLocation();
        return EntityLocation.from(location);
    }

    @NotNull
    public UUID getWorldId() {
        return this.worldId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getPitch() {
        return this.pitch;
    }

    @Nullable
    public World getWorld() {
        UUID worldId = this.getWorldId();
        return Bukkit.getWorld((UUID)worldId);
    }

    @Nullable
    public Location asLocation() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double yaw = this.getYaw();
        double pitch = this.getPitch();
        return new Location(world, x, y, z, (float)yaw, (float)pitch);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof EntityLocation)) {
            return false;
        }
        UUID thisWorldId = this.getWorldId();
        double thisX = this.getX();
        double thisY = this.getY();
        double thisZ = this.getZ();
        double thisYaw = this.getYaw();
        double thisPitch = this.getPitch();
        EntityLocation other = (EntityLocation)object;
        UUID otherWorldId = other.getWorldId();
        double otherX = other.getX();
        double otherY = other.getY();
        double otherZ = other.getZ();
        double otherYaw = other.getYaw();
        double otherPitch = other.getPitch();
        boolean checkId = Objects.equals(thisWorldId, otherWorldId);
        boolean checkCoordinates = thisX == otherX && thisY == otherY && thisZ == otherZ;
        boolean checkFacing = thisYaw == otherYaw && thisPitch == otherPitch;
        return checkId && checkCoordinates && checkFacing;
    }

    public int hashCode() {
        return Objects.hash(this.worldId, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public String toString() {
        UUID worldId = this.getWorldId();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double yaw = this.getYaw();
        double pitch = this.getPitch();
        return String.format(Locale.US, "EntityLocation{worldId=%s,x=%s,y=%s,z=%s,yaw=%s,pitch=%s}", worldId, x, y, z, yaw, pitch);
    }
}

