/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.location;

import com.github.sirblobman.api.utility.Validate;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockLocation {
    private final UUID worldId;
    private final int x;
    private final int y;
    private final int z;

    public BlockLocation(@NotNull UUID worldId, int x, int y, int z) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @NotNull
    public static BlockLocation from(@NotNull World world, int x, int y, int z) {
        UUID worldId = world.getUID();
        return new BlockLocation(worldId, x, y, z);
    }

    @NotNull
    public static BlockLocation from(@NotNull Block block) {
        World world = block.getWorld();
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        return BlockLocation.from(world, x, y, z);
    }

    @NotNull
    public static BlockLocation from(@NotNull Location location) {
        World world = location.getWorld();
        Validate.notNull(world, "world must not be null!");
        Block block = location.getBlock();
        return BlockLocation.from(block);
    }

    @NotNull
    public static BlockLocation from(Entity entity) {
        Location location = entity.getLocation();
        return BlockLocation.from(location);
    }

    @NotNull
    public UUID getWorldId() {
        return this.worldId;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    @Nullable
    public World getWorld() {
        UUID worldId = this.getWorldId();
        return Bukkit.getWorld((UUID)worldId);
    }

    @Nullable
    public Location asLocation() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        return new Location(world, (double)x, (double)y, (double)z, 0.0f, 0.0f);
    }

    @Nullable
    public Block asBlock() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        return world.getBlockAt(x, y, z);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BlockLocation)) {
            return false;
        }
        BlockLocation other = (BlockLocation)object;
        boolean checkId = Objects.equals(this.worldId, other.worldId);
        return checkId && this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return Objects.hash(this.worldId, this.x, this.y, this.z);
    }

    @NotNull
    public String toString() {
        UUID worldId = this.getWorldId();
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        return String.format(Locale.US, "BlockLocation{worldId=%s,x=%s,y=%s,z=%s}", worldId, x, y, z);
    }
}

